﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0;
using System;
using System.IO;
using System.Xml.Serialization;

namespace NWCore.Serializer.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// 全エミッタ共通データのシリアライズ用クラスです
    /// </summary>
    [CoupledType(typeof(ComplexEmitterData))]
    [XmlType("ComplexEmitterData")]
    public class ComplexEmitterDataXml
    {
        /// <summary>
        /// 編集用データです。
        /// </summary>
        protected EmitterData m_data;

        /// <summary>
        /// Normalize path to file name.
        /// </summary>
        protected bool m_bNormalizePath = true;

        #region Construtors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ComplexEmitterDataXml()
        {
            m_data = new EmitterData();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ComplexEmitterDataXml( EmitterData emitter,
                                      bool bNormalizePath = true )
            : this()
        {
            m_data.Set(emitter);
            m_bNormalizePath = bNormalizePath;
        }

        #endregion

        /// <summary>
        /// EmitterData を取得します。
        /// </summary>
        public EmitterData EditData
        {
            get { return m_data; }
        }

        #region Properties - EditData

        /// <summary>
        /// 編集用データ
        /// </summary>
        public EditDataEmitterXml editor_data
        {
            get { return m_data.EditData.CreateEditDataXml(); }
            set { m_data.EditData.Set(value.EditData); }
        }

        #endregion

        #region Properties - SimpleEmitter

        /// <summary>
        /// アドレス解決後の名前
        /// </summary>
        public string name
        {
            get { return m_data.Name; }
            set { m_data.Name = value; }
        }

        /// <summary>
        /// テクスチャー
        /// </summary>
        public string texture
        {
            get
            {
                if ( String.IsNullOrEmpty(m_data.TexPatData.UI_texPatFileName)==false )
                {
                    if ( m_bNormalizePath==true )
                        return System.IO.Path.GetFileName(m_data.TexPatData.UI_texPatFileName);
                    else
                        return m_data.TexPatData.UI_texPatFileName;
                }
                else
                {
                    return String.Empty;
                }
            }
            set
            {
                m_data.TexPatData.UI_texPatFileName = value;
            }
        }

        /// <summary>
        /// タイプ
        /// </summary>
        public EmitterType type
        {
            get { return m_data.Type; }
            set { m_data.Type = value; }
        }

        /// <summary>
        /// ボリュームのタイプ
        /// </summary>
        public VolumeType volumeType
        {
            get { return m_data.VolumeType; }
            set { m_data.VolumeType = value; }
        }

        /// <summary>
        /// Blend type
        /// </summary>
        public BlendType UI_blendType
        {
            get { return m_data.BlendType; }
            set { m_data.BlendType = value; }
        }

        /// <summary>
        /// 回転タイプ
        /// </summary>
        public PtclRotType UI_rotType
        {
            get { return m_data.UI_rotType; }
            set { m_data.UI_rotType = value; }
        }

        /// <summary>
        /// カラータイプ名
        /// </summary>
        public string UI_colorType
        {
            get { return Constances.GetColorTypeName(m_data.UI_colorType); }
            set { m_data.UI_colorType = Constances.SetColorTypeName(value); }
        }

        /// <summary>
        /// ビルボードのタイプ
        /// </summary>
        public BillboardType billboardType
        {
            get { return m_data.BillboardType; }
            set { m_data.BillboardType = value; }
        }

        /// <summary>
        /// 追随タイプ
        /// </summary>
        public FollowType UI_followType
        {
            get { return m_data.UI_followType; }
            set { m_data.UI_followType = value; }
        }

        /// <summary>
        /// テクスチャーアドレス
        /// </summary>
        public TextureAddressing UI_textureAddressing
        {
            get { return m_data.TexPatData.UI_textureAddressing; }
            set { m_data.TexPatData.UI_textureAddressing = value; }
        }

        /// <summary>
        /// アルファ
        /// </summary>
        public AlphaDst UI_alphaDstType
        {
            get { return m_data.UI_alphaDstType; }
            set { m_data.UI_alphaDstType = value; }
        }

        /// <summary>
        /// Ｚバッファー、αテストタイプ
        /// </summary>
        public ZBufATestType zBufATestType
        {
            get { return m_data.ZBufATestType; }
            set { m_data.ZBufATestType = value; }
        }

        /// <summary>
        /// フィルタモード
        /// </summary>
        public FilterMode UI_texFilterMode
        {
            get { return m_data.TexPatData.UI_texFilterMode; }
            set { m_data.TexPatData.UI_texFilterMode = value; }
        }

        /// <summary>
        /// FadeOutType
        /// </summary>
        public FadeOutType UI_fadeOutType
        {
            get { return m_data.UI_fadeOutType; }
            set { m_data.UI_fadeOutType = value; }
        }

        /// <summary>
        /// サブ・テクスチャー
        /// </summary>
        public string subTexture
        {
            get
            {
                if (String.IsNullOrEmpty(m_data.SubTexPatData.UI_texPatFileName) == false)
                {
                    if ( m_bNormalizePath==true )
                        return System.IO.Path.GetFileName( m_data.SubTexPatData.UI_texPatFileName );
                    else
                        return m_data.SubTexPatData.UI_texPatFileName;
                }
                else
                {
                    return String.Empty;
                }
            }
            set { m_data.SubTexPatData.UI_texPatFileName = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_randomSeed
        {
            get { return m_data.UI_randomSeed; }
            set { m_data.UI_randomSeed = value; }
        }


        /// <summary>
        /// ボリューム半径
        /// </summary>
        public Vector3Xml volumeRadius
        {
            get { return UtilityXml.ToVector3Xml(m_data.VolumeRadius); }
            set { m_data.VolumeRadius = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_volumeSweep
        {
            get { return (int)m_data.VolumeSweepParam; }
            set { m_data.VolumeSweepParam = (uint)value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_volumeSweepStart
        {
            get { return (int)m_data.VolumeSweepStart; }
            set { m_data.VolumeSweepStart = (uint)value; }
        }

        /// <summary>
        ///  テーブルを使うボリューム形状のインデックス
        /// </summary>
        public int volumeTblIndex
        {
            get { return m_data.VolumeTblIndex; }
            set { m_data.VolumeTblIndex = value; }
        }

        /// <summary>
        /// フォグ
        /// </summary>
        public int UI_Fog
        {
            get { return m_data.UI_Fog; }
            set { m_data.UI_Fog = value; }
        }

        /// <summary>
        /// エミッタ速度
        /// </summary>
        public float figureVel
        {
            get { return m_data.FigureVelocity; }
            set { m_data.FigureVelocity = value; }
        }

        /// <summary>
        /// エミッタ速度
        /// </summary>
        public float emitterVel
        {
            get { return m_data.EmitterVelocity; }
            set { m_data.EmitterVelocity = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_initVelRnd
        {
            get { return m_data.UI_initVelRnd; }
            set { m_data.UI_initVelRnd = value; }
        }

        /// <summary>
        /// 拡散ベクトル
        /// </summary>
        public Vector3Xml spreadVec
        {
            get { return UtilityXml.ToVector3Xml(m_data.SpreadVec); }
            set { m_data.SpreadVec = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        /// エミッタ速度の方向
        /// </summary>
        public Vector3Xml emitterVelDir
        {
            get { return UtilityXml.ToVector3Xml(m_data.EmitterVelDir); }
            set { m_data.EmitterVelDir = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        /// 放出開始フレーム
        /// </summary>
        public int startFrame
        {
            get { return m_data.StartFrame; }
            set { m_data.StartFrame = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_emitTime
        {
            get { return m_data.UI_emitTime; }
            set { m_data.UI_emitTime = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_isOneTime
        {
            get { return (m_data.UI_isOneTime ? 1 : 0); }
            set { m_data.UI_isOneTime = (value != 0); }
        }

        /// <summary>
        /// ステップ値
        /// </summary>
        public int lifeStep
        {
            get { return m_data.LifeStep; }
            set { m_data.LifeStep = value; }
        }

        /// <summary>
        /// Emitter放出レート（旧ファイルの対応）
        /// </summary>
        public int emitRate
        {
            get { return m_data.EmitRate; }
            set { m_data.EmitRate = value; }
        }

        /// <summary>
        /// Emitter放出レート
        /// </summary>
        public int UI_emitRate
        {
            get { return m_data.EmitRate; }
            set { m_data.EmitRate = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_life
        {
            get { return m_data.AnimEditData.UI_life; }
            set { m_data.AnimEditData.UI_life = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_lifeRnd
        {
            get { return m_data.AnimEditData.UI_lifeRnd; }
            set { m_data.AnimEditData.UI_lifeRnd = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint UI_lifeInfinit
        {
            get { return m_data.AnimEditData.UI_lifeInfinit; }
            set { m_data.AnimEditData.UI_lifeInfinit = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_lifeStepRnd
        {
            get { return m_data.LifeStepRnd; }
            set { m_data.LifeStepRnd = value; }
        }

        /// <summary>
        /// 空気抵抗
        /// </summary>
        public float airRegist
        {
            get { return m_data.AirRegist; }
            set { m_data.AirRegist = value; }
        }

        /// <summary>
        /// 重力方向
        /// </summary>
        public Vector3Xml UI_gravityDir
        {
            get { return UtilityXml.ToVector3Xml(m_data.GravityDir); }
            set { m_data.GravityDir = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        /// 重力の大きさ
        /// </summary>
        public float UI_gravity
        {
            get { return m_data.GravityVolume; }
            set { m_data.GravityVolume = value; }
        }

        /// <summary>
        /// 将来の為にタイプとして持たせる
        /// </summary>
        public int UI_isFieldCalcType
        {
            get { return m_data.IsWorldField ? 1 : 0; }
            set { m_data.IsWorldField = (value != 0); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_color1
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.AnimEditData.UI_color1); }
            set { m_data.AnimEditData.UI_color1 = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_color2
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.AnimEditData.UI_color2); }
            set { m_data.AnimEditData.UI_color2 = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_color3
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.AnimEditData.UI_color3); }
            set { m_data.AnimEditData.UI_color3 = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_constColor
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.UI_constColor); }
            set { m_data.UI_constColor = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime1
        {
            get { return m_data.AnimEditData.UI_colorTime1; }
            set { m_data.AnimEditData.UI_colorTime1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime2
        {
            get { return m_data.AnimEditData.UI_colorTime2; }
            set { m_data.AnimEditData.UI_colorTime2 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_colorTime3
        {
            get { return m_data.AnimEditData.UI_colorTime3; }
            set { m_data.AnimEditData.UI_colorTime3 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_numColorRepeat
        {
            get { return m_data.AnimEditData.UI_numColorRepeat; }
            set { m_data.AnimEditData.UI_numColorRepeat = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha1
        {
            get { return m_data.AnimEditData.UI_alpha1; }
            set { m_data.AnimEditData.UI_alpha1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha2
        {
            get { return m_data.AnimEditData.UI_alpha2; }
            set { m_data.AnimEditData.UI_alpha2 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_alpha3
        {
            get { return m_data.AnimEditData.UI_alpha3; }
            set { m_data.AnimEditData.UI_alpha3 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime1
        {
            get { return m_data.AnimEditData.UI_alphaTime1; }
            set { m_data.AnimEditData.UI_alphaTime1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_alphaTime2
        {
            get { return m_data.AnimEditData.UI_alphaTime2; }
            set { m_data.AnimEditData.UI_alphaTime2 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_scale1
        {
            get { return m_data.AnimEditData.UI_scale1; }
            set { m_data.AnimEditData.UI_scale1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2Xml UI_scale2
        {
            get { return UtilityXml.ToVector2Xml(m_data.AnimEditData.UI_scale2); }
            set { m_data.AnimEditData.UI_scale2 = UtilityXml.ToVector2(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_scale3
        {
            get { return m_data.AnimEditData.UI_scale3; }
            set { m_data.AnimEditData.UI_scale3 = value; }
        }


        /// <summary>
        ///
        /// </summary>
        public int UI_scaleTime1
        {
            get { return m_data.AnimEditData.UI_scaleTime1; }
            set { m_data.AnimEditData.UI_scaleTime1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_scaleTime2
        {
            get { return m_data.AnimEditData.UI_scaleTime2; }
            set { m_data.AnimEditData.UI_scaleTime2 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_scaleRand
        {
            get { return m_data.UI_scaleRand; }
            set { m_data.UI_scaleRand = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRot
        {
            get { return m_data.UI_initRot; }
            set { m_data.UI_initRot.Set(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRotRand
        {
            get { return m_data.UI_initRotRand; }
            set { m_data.UI_initRotRand.Set(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVel
        {
            get { return m_data.UI_rotVel; }
            set { m_data.UI_rotVel.Set(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVelRand
        {
            get { return m_data.UI_rotVelRand; }
            set { m_data.UI_rotVelRand.Set(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2Xml UI_rotBasis
        {
            get { return UtilityXml.ToVector2Xml(m_data.UI_rotBasis); }
            set { m_data.UI_rotBasis = UtilityXml.ToVector2(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml UI_transformScale
        {
            get { return UtilityXml.ToVector3Xml(m_data.UI_transformScale); }
            set { m_data.UI_transformScale = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_fadeAlphaFrameInFade
        {
            get { return m_data.UI_fadeAlphaFrameInFade; }
            set { m_data.UI_fadeAlphaFrameInFade = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivX
        {
            get { return m_data.TexPatData.UI_texPatDivX; }
            set { m_data.TexPatData.UI_texPatDivX = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatDivY
        {
            get { return m_data.TexPatData.UI_texPatDivY; }
            set { m_data.TexPatData.UI_texPatDivY = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatNumPattern
        {
            get { return m_data.TexPatData.UI_texPatNumPattern; }
            set { m_data.TexPatData.UI_texPatNumPattern = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint UI_texPatFreqFrame
        {
            get { return m_data.TexPatData.UI_texPatFreqFrame; }
            set { m_data.TexPatData.UI_texPatFreqFrame = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_numUseTexPatTbl
        {
            get { return m_data.TexPatData.UI_numUseTexPatTbl; }
            set { m_data.TexPatData.UI_numUseTexPatTbl = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_texPatAnimMode
        {
            get { return m_data.TexPatData.UI_texPatAnimMode; }
            set { m_data.TexPatData.UI_texPatAnimMode = value; }
        }

        /// <summary>
        /// 0:アニメなし 1:アニメ有り
        /// </summary>
        public int UI_texPatAnim
        {
            get { return m_data.TexPatData.UI_texPatAnim; }
            set { m_data.TexPatData.UI_texPatAnim = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_texWrapU
        {
            get { return (int)m_data.TexPatData.UI_texWrapU; }
            set { m_data.TexPatData.UI_texWrapU = (TextureWrapMode)value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_texWrapV
        {
            get { return (int)m_data.TexPatData.UI_texWrapV; }
            set { m_data.TexPatData.UI_texWrapV = (TextureWrapMode)value; }
        }

#if true
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_0
        {
            get { return m_data.TexPatData.UI_texPatTbl[0]; }
            set { m_data.TexPatData.UI_texPatTbl[0] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_1
        {
            get { return m_data.TexPatData.UI_texPatTbl[1]; }
            set { m_data.TexPatData.UI_texPatTbl[1] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_2
        {
            get { return m_data.TexPatData.UI_texPatTbl[2]; }
            set { m_data.TexPatData.UI_texPatTbl[2] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_3
        {
            get { return m_data.TexPatData.UI_texPatTbl[3]; }
            set { m_data.TexPatData.UI_texPatTbl[3] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_4
        {
            get { return m_data.TexPatData.UI_texPatTbl[4]; }
            set { m_data.TexPatData.UI_texPatTbl[4] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_5
        {
            get { return m_data.TexPatData.UI_texPatTbl[5]; }
            set { m_data.TexPatData.UI_texPatTbl[5] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_6
        {
            get { return m_data.TexPatData.UI_texPatTbl[6]; }
            set { m_data.TexPatData.UI_texPatTbl[6] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_7
        {
            get { return m_data.TexPatData.UI_texPatTbl[7]; }
            set { m_data.TexPatData.UI_texPatTbl[7] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_8
        {
            get { return m_data.TexPatData.UI_texPatTbl[8]; }
            set { m_data.TexPatData.UI_texPatTbl[8] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_9
        {
            get { return m_data.TexPatData.UI_texPatTbl[9]; }
            set { m_data.TexPatData.UI_texPatTbl[9] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_10
        {
            get { return m_data.TexPatData.UI_texPatTbl[10]; }
            set { m_data.TexPatData.UI_texPatTbl[10] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_11
        {
            get { return m_data.TexPatData.UI_texPatTbl[11]; }
            set { m_data.TexPatData.UI_texPatTbl[11] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_12
        {
            get { return m_data.TexPatData.UI_texPatTbl[12]; }
            set { m_data.TexPatData.UI_texPatTbl[12] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_13
        {
            get { return m_data.TexPatData.UI_texPatTbl[13]; }
            set { m_data.TexPatData.UI_texPatTbl[13] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_14
        {
            get { return m_data.TexPatData.UI_texPatTbl[14]; }
            set { m_data.TexPatData.UI_texPatTbl[14] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_15
        {
            get { return m_data.TexPatData.UI_texPatTbl[15]; }
            set { m_data.TexPatData.UI_texPatTbl[15] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_16
        {
            get { return m_data.TexPatData.UI_texPatTbl[16]; }
            set { m_data.TexPatData.UI_texPatTbl[16] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_17
        {
            get { return m_data.TexPatData.UI_texPatTbl[17]; }
            set { m_data.TexPatData.UI_texPatTbl[17] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_18
        {
            get { return m_data.TexPatData.UI_texPatTbl[18]; }
            set { m_data.TexPatData.UI_texPatTbl[18] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_19
        {
            get { return m_data.TexPatData.UI_texPatTbl[19]; }
            set { m_data.TexPatData.UI_texPatTbl[19] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_20
        {
            get { return m_data.TexPatData.UI_texPatTbl[20]; }
            set { m_data.TexPatData.UI_texPatTbl[20] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_21
        {
            get { return m_data.TexPatData.UI_texPatTbl[21]; }
            set { m_data.TexPatData.UI_texPatTbl[21] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_22
        {
            get { return m_data.TexPatData.UI_texPatTbl[22]; }
            set { m_data.TexPatData.UI_texPatTbl[22] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_23
        {
            get { return m_data.TexPatData.UI_texPatTbl[23]; }
            set { m_data.TexPatData.UI_texPatTbl[23] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_24
        {
            get { return m_data.TexPatData.UI_texPatTbl[24]; }
            set { m_data.TexPatData.UI_texPatTbl[24] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_25
        {
            get { return m_data.TexPatData.UI_texPatTbl[25]; }
            set { m_data.TexPatData.UI_texPatTbl[25] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_26
        {
            get { return m_data.TexPatData.UI_texPatTbl[26]; }
            set { m_data.TexPatData.UI_texPatTbl[26] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_27
        {
            get { return m_data.TexPatData.UI_texPatTbl[27]; }
            set { m_data.TexPatData.UI_texPatTbl[27] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_28
        {
            get { return m_data.TexPatData.UI_texPatTbl[28]; }
            set { m_data.TexPatData.UI_texPatTbl[28] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_29
        {
            get { return m_data.TexPatData.UI_texPatTbl[29]; }
            set { m_data.TexPatData.UI_texPatTbl[29] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_30
        {
            get { return m_data.TexPatData.UI_texPatTbl[30]; }
            set { m_data.TexPatData.UI_texPatTbl[30] = value; }
        }
        /// <summary>
        /// NumTexPatTbl
        /// </summary>
        public int UI_texPatTbl_31
        {
            get { return m_data.TexPatData.UI_texPatTbl[31]; }
            set { m_data.TexPatData.UI_texPatTbl[31] = value; }
        }
#else
        /// <summary>
        /// /*cNumTexPatTbl*/
        /// </summary>
        [XmlArrayItem("texPat")]
        public int[] UI_texPatTbl
        {
            get { return m_data.TexPatData.UI_texPatTbl; }
            set { m_data.TexPatData.UI_texPatTbl = value; }
        }
#endif

        #endregion

        #region Properties - Child

        /// <summary>
        /// ブレンドのタイプ
        /// </summary>
        public BlendType UI_childBlendType
        {
            get { return m_data.ChildAssistData.UI_childBlendType; }
            set { m_data.ChildAssistData.UI_childBlendType = value; }
        }

        /// <summary>
        /// ビルボードタイプ
        /// </summary>
        public BillboardType childBillboardType
        {
            get { return m_data.ChildData.BillboardType; }
            set { m_data.ChildData.BillboardType = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public string UI_childColorType
        {
            get
            {
                return Constances.GetColorTypeName(
                    m_data.ChildAssistData.UI_childColorType);
            }
            set
            {
                m_data.ChildAssistData.UI_childColorType =
                    Constances.SetColorTypeName(value);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public AlphaDst UI_childAlphaDstType
        {
            get { return m_data.ChildAssistData.UI_childAlphaDstType; }
            set { m_data.ChildAssistData.UI_childAlphaDstType = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public PtclRotType UI_childRotType
        {
            get { return m_data.ChildAssistData.UI_childRotType; }
            set { m_data.ChildAssistData.UI_childRotType = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public string UI_childColorInheritType
        {
            get
            {
                return Constances.GetColorInheritTypeNames(
                    m_data.ChildAssistData.UI_childColorInheritType);
            }
            set
            {
                m_data.ChildAssistData.UI_childColorInheritType =
                    Constances.SetColorInheritTypeNames(value);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public TextureAddressing UI_childTextureAddressing
        {
            get { return m_data.ChildTexPatData.UI_textureAddressing; }
            set { m_data.ChildTexPatData.UI_textureAddressing = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public StripeType stripeType
        {
            get { return m_data.StripeData.Type; }
            set { m_data.StripeData.Type = value; }
        }

        /// <summary>
        /// Ｚバッファー、αテストタイプ
        /// </summary>
        public ZBufATestType childZBufATestType
        {
            get { return m_data.ChildData.ZBufATestType; }
            set { m_data.ChildData.ZBufATestType = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public FilterMode UI_childTexFilterMode
        {
            get { return m_data.ChildTexPatData.UI_texFilterMode; }
            set { m_data.ChildTexPatData.UI_texFilterMode = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public string childTexture
        {
            //TODO:まだ未完成です。
            get
            {
                if (String.IsNullOrEmpty(m_data.ChildTexPatData.UI_texPatFileName) == false)
                {
                    if ( m_bNormalizePath==true )
                        return System.IO.Path.GetFileName(m_data.ChildTexPatData.UI_texPatFileName);
                    else
                        return m_data.ChildTexPatData.UI_texPatFileName;
                }
                else
                {
                    return String.Empty;
                }
            }
            set { m_data.ChildTexPatData.UI_texPatFileName = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint childFlg
        {
            get { return m_data.ChildFlag.Flag; }
            set { m_data.ChildFlag.Flag = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childLife
        {
            get { return m_data.ChildAssistData.UI_childLife; }
            set { m_data.ChildAssistData.UI_childLife = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2Xml UI_childRotBasis
        {
            get { return UtilityXml.ToVector2Xml(m_data.ChildAssistData.UI_childRotBasis); }
            set { m_data.ChildAssistData.UI_childRotBasis = UtilityXml.ToVector2(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int childEmitRate
        {
            get { return m_data.ChildData.EmitRate; }
            set { m_data.ChildData.EmitRate = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int childEmitTiming
        {
            get { return m_data.ChildData.EmitTiming; }
            set { m_data.ChildData.EmitTiming = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int childEmitStep
        {
            get { return m_data.ChildData.EmitStep; }
            set { m_data.ChildData.EmitStep = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childInitPosRand
        {
            get { return m_data.ChildData.InitPosRand; }
            set { m_data.ChildData.InitPosRand = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childVelInheritRate
        {
            get { return m_data.ChildData.VelInheritRate; }
            set { m_data.ChildData.VelInheritRate = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childFigureVel
        {
            get { return m_data.ChildData.FigureVelocity; }
            set { m_data.ChildData.FigureVelocity = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml childRandVel
        {
            get { return UtilityXml.ToVector3Xml(m_data.ChildData.RandVel); }
            set { m_data.ChildData.RandVel = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public float childAirRegist
        {
            get { return m_data.ChildData.AirRegist; }
            set { m_data.ChildData.AirRegist = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexPatDivX
        {
            get { return m_data.ChildTexPatData.UI_texPatDivX; }
            set { m_data.ChildTexPatData.UI_texPatDivX = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexPatDivY
        {
            get { return m_data.ChildTexPatData.UI_texPatDivY; }
            set { m_data.ChildTexPatData.UI_texPatDivY = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint UI_childTexPatNumPattern
        {
            get { return m_data.ChildTexPatData.UI_texPatNumPattern; }
            set { m_data.ChildTexPatData.UI_texPatNumPattern = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public uint UI_childTexPatFreqFrame
        {
            get { return m_data.ChildTexPatData.UI_texPatFreqFrame; }
            set { m_data.ChildTexPatData.UI_texPatFreqFrame = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childNumUseTexPatTbl
        {
            get { return m_data.ChildTexPatData.UI_numUseTexPatTbl; }
            set { m_data.ChildTexPatData.UI_numUseTexPatTbl = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexPatAnimMode
        {
            get { return m_data.ChildTexPatData.UI_texPatAnimMode; }
            set { m_data.ChildTexPatData.UI_texPatAnimMode = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexPatAnim
        {
            get { return m_data.ChildTexPatData.UI_texPatAnim; }
            set { m_data.ChildTexPatData.UI_texPatAnim = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexWrapU
        {
            get { return (int)m_data.ChildTexPatData.UI_texWrapU; }
            set { m_data.ChildTexPatData.UI_texWrapU = (TextureWrapMode)value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childTexWrapV
        {
            get { return (int)m_data.ChildTexPatData.UI_texWrapV; }
            set { m_data.ChildTexPatData.UI_texWrapV = (TextureWrapMode)value; }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_childConstColor
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.ChildAssistData.UI_childConstColor); }
            set { m_data.ChildAssistData.UI_childConstColor = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_childColor
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.ChildAssistData.UI_childColor); }
            set { m_data.ChildAssistData.UI_childColor = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public RgbaColorXml UI_childInheritanceColor
        {
            get { return UtilityXml.ToRgbaColorXml(m_data.ChildAssistData.UI_childInheritanceColor); }
            set { m_data.ChildAssistData.UI_childInheritanceColor = UtilityXml.ToRgbaColor(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public float childAlpha
        {
            get { return m_data.ChildData.Alpha; }
            set { m_data.ChildData.Alpha = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childAlphaTarget
        {
            get { return m_data.ChildData.AlphaTarget; }
            set { m_data.ChildData.AlphaTarget = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childAlphaInit
        {
            get { return m_data.ChildData.AlphaInit; }
            set { m_data.ChildData.AlphaInit = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childAlphaSec
        {
            get { return m_data.ChildAssistData.UI_childAlphaSec; }
            set { m_data.ChildAssistData.UI_childAlphaSec = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childAlphaBaseSec
        {
            get { return m_data.ChildAssistData.UI_childAlphaBaseSec; }
            set { m_data.ChildAssistData.UI_childAlphaBaseSec = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float childScaleInheritRate
        {
            get { return m_data.ChildData.ScaleInheritRate; }
            set { m_data.ChildData.ScaleInheritRate = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2Xml childScale
        {
            get { return UtilityXml.ToVector2Xml(m_data.ChildData.Scale); }
            set { m_data.ChildData.Scale = UtilityXml.ToVector2(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_childScaleSec
        {
            get { return m_data.ChildAssistData.UI_childScaleSec; }
            set { m_data.ChildAssistData.UI_childScaleSec = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2i UI_childScaleTarget
        {
            get { return m_data.ChildAssistData.UI_childScaleTarget; }
            set { m_data.ChildAssistData.UI_childScaleTarget = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childInitRot
        {
            get { return m_data.ChildAssistData.UI_childInitRot; }
            set { m_data.ChildAssistData.UI_childInitRot = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childInitRotRand
        {
            get { return m_data.ChildAssistData.UI_childInitRotRand; }
            set { m_data.ChildAssistData.UI_childInitRotRand = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childRotVel
        {
            get { return m_data.ChildAssistData.UI_childRotVel; }
            set { m_data.ChildAssistData.UI_childRotVel = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_childRotVelRand
        {
            get { return m_data.ChildAssistData.UI_childRotVelRand; }
            set { m_data.ChildAssistData.UI_childRotVelRand = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float UI_childGravity
        {
            get { return m_data.ChildAssistData.UI_childGravity; }
            set { m_data.ChildAssistData.UI_childGravity = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml UI_childGravityDir
        {
            get { return UtilityXml.ToVector3Xml(m_data.ChildAssistData.UI_childGravityDir); }
            set { m_data.ChildAssistData.UI_childGravityDir = UtilityXml.ToVector3(value); }
        }

        #endregion

        #region Properties - Field

        /// <summary>
        ///
        /// </summary>
        public uint fieldFlg
        {
            get { return m_data.FieldFlag.Flag; }
            set { m_data.FieldFlag.Flag = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int fieldRandomBlank
        {
            get { return m_data.FieldRandomData.Blank; }
            set { m_data.FieldRandomData.Blank = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml fieldRandomVelAdd
        {
            get { return UtilityXml.ToVector3Xml(m_data.FieldRandomData.VelocityAddition); }
            set { m_data.FieldRandomData.VelocityAddition = UtilityXml.ToVector3(value); }
        }


        /// <summary>
        ///
        /// </summary>
        public float fieldMagnetPower
        {
            get { return m_data.FieldMagnetData.FieldMagnetPower; }
            set { m_data.FieldMagnetData.FieldMagnetPower = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml fieldMagnetPos
        {
            get { return UtilityXml.ToVector3Xml(m_data.FieldMagnetData.FieldMagnetPos); }
            set { m_data.FieldMagnetData.FieldMagnetPos = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public uint fieldMagnetFlg
        {
            get { return m_data.FieldMagnetData.Flag.Flag; }
            set { m_data.FieldMagnetData.Flag.Flag = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int fieldSpinRotate
        {
            get { return m_data.FieldSpinData.FieldSpinRotation; }
            set { m_data.FieldSpinData.FieldSpinRotation = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int fieldSpinAxis
        {
            get { return m_data.FieldSpinData.FieldSpinAxis; }
            set { m_data.FieldSpinData.FieldSpinAxis = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int fieldCollisionType
        {
            get { return m_data.FieldCollisionData.Type; }
            set { m_data.FieldCollisionData.Type = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int fieldCollisionIsWorld
        {
            get { return m_data.FieldCollisionData.IsWorld ? 1 : 0; }
            set { m_data.FieldCollisionData.IsWorld = (value != 0); }
        }

        /// <summary>
        ///
        /// </summary>
        public float fieldCollisionCoord
        {
            get { return m_data.FieldCollisionData.Coordinate; }
            set { m_data.FieldCollisionData.Coordinate = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float fieldCollisionCoef
        {
            get { return m_data.FieldCollisionData.Coefficient; }
            set { m_data.FieldCollisionData.Coefficient = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml fieldConvergencePos
        {
            get { return UtilityXml.ToVector3Xml(m_data.FieldConvergenceData.Position); }
            set { m_data.FieldConvergenceData.Position = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public float fieldConvergenceRatio
        {
            get { return m_data.FieldConvergenceData.Ratio; }
            set { m_data.FieldConvergenceData.Ratio = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml fieldPosAdd
        {
            get { return UtilityXml.ToVector3Xml(m_data.FieldPosAddData.Addition); }
            set { m_data.FieldPosAddData.Addition = UtilityXml.ToVector3(value); }
        }

        #endregion

        #region Properties - Fluctuation

        /// <summary>
        /// FluctuationFlag を使用。ビットによって機能が違います。
        /// </summary>
        public uint fluctuationFlg
        {
            get { return m_data.FluctuationFlag.Flag; }
            set { m_data.FluctuationFlag.Flag = value; }
        }

        /// <summary>
        /// 振幅スケール
        /// </summary>
        public float fluctuationScale
        {
            get { return m_data.FluctuationData.Scale; }
            set { m_data.FluctuationData.Scale = value; }
        }

        /// <summary>
        /// 位相ランダム(0 / 1)
        /// </summary>
        public uint fluctuationPhaseRnd
        {
            get { return m_data.FluctuationData.PhaseRange; }
            set { m_data.FluctuationData.PhaseRange = value; }
        }

        /// <summary>
        /// 周期
        /// </summary>
        public int UI_fluctuationFreq
        {
            get { return m_data.FluctuationData.Frequency; }
            set { m_data.FluctuationData.Frequency = value; }
        }

        #endregion

        #region Properties - Stripe

        /// <summary>
        ///
        /// </summary>
        public int stripeFlg
        {
            get { return (int)m_data.StripeFlag; }
            set { m_data.StripeFlag = (StripeFlag)value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float stripeStartAlpha
        {
            get { return m_data.StripeData.StartAlpha; }
            set { m_data.StripeData.StartAlpha = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float stripeEndAlpha
        {
            get { return m_data.StripeData.EndAlpha; }
            set { m_data.StripeData.EndAlpha = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector2Xml stripeUVScroll
        {
            get { return UtilityXml.ToVector2Xml(m_data.StripeData.UVScroll); }
            set { m_data.StripeData.UVScroll = UtilityXml.ToVector2(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public int stripeNumHistory
        {
            get { return m_data.StripeData.NumHistory; }
            set { m_data.StripeData.NumHistory = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int UI_stripeHistoryStep
        {
            get { return m_data.UI_stripeHistoryStep; }
            set { m_data.UI_stripeHistoryStep = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public float stripeDirInterpolate
        {
            get { return m_data.StripeData.DirInterpolation; }
            set { m_data.StripeData.DirInterpolation = value; }
        }

        #endregion

        #region Shader

        /// <summary>
        /// シェーダーのタイプ
        /// </summary>
        public int useSortParticle
        {
            get { return (int)m_data.UseSortParticle; }
            set { m_data.UseSortParticle = (ShaderType)value; }
        }

        /// <summary>
        /// シェーダーパラメータ0
        /// </summary>
        public float shaderParam0
        {
            get { return m_data.ShaderParam0; }
            set { m_data.ShaderParam0 = value; }
        }

        /// <summary>er
        /// シェーダーパラメータ1
        /// </summary>
        public float shaderParam1
        {
            get { return m_data.ShaderParam1; }
            set { m_data.ShaderParam1 = value; }
        }

        #endregion

        #region UVScroll

        /// <summary>
        /// ＵＶスクロール加算値
        /// </summary>
        public Vector2Xml uvScroll
        {
            get { return UtilityXml.ToVector2Xml(m_data.UVScroll); }
            set { m_data.UVScroll = UtilityXml.ToVector2(value); }
        }

        #endregion

        #region Transform

        /// <summary>
        ///
        /// </summary>
        public Vector3Xml UI_transformTrans
        {
            get { return UtilityXml.ToVector3Xml(m_data.UI_transformTrans); }
            set { m_data.UI_transformTrans = UtilityXml.ToVector3(value); }
        }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_transformRot
        {
            get { return m_data.UI_transformRot; }
            set { m_data.UI_transformRot = value; }
        }

        #endregion

        /// <summary>
        /// ソートオーダー
        /// </summary>
        public int order
        {
            get { return m_data.SortOrder; }
            set { m_data.SortOrder = value; }
        }
    }
}
