﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Core;

namespace EffectMaker.Foundation.Log
{
    /// <summary>
    /// Log handler interface.
    /// </summary>
    public interface ILogHandler
    {
        /// <summary>
        /// Called when messages being send to the logger.
        /// </summary>
        /// <param name="destination">The output destination.</param>
        /// <param name="level">The log level.</param>
        /// <param name="message">The message to output.</param>
        void Log(IEnumerable<string> destination, LogLevels level, string message);
    }

    /// <summary>
    /// ログビューのサンプル。
    /// </summary>
    [Alias("SampleLogView")]
    public class SampleLogView : ILogHandler
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public SampleLogView()
        {
            // Register this to Logger.
            Logger.RegisterLogHandler(this);
        }

        /// <summary>
        /// Called when messages being send to the logger.
        /// </summary>
        /// <param name="destination">The output destination.</param>
        /// <param name="level">The log level.</param>
        /// <param name="message">The message to output.</param>
        public void Log(
            IEnumerable<string> destination, LogLevels level, string message)
        {
            // Output log!
            Console.WriteLine("SampleLogView : {0} - {1}", level.ToString(), message);
        }
    }

    /// <summary>
    /// デバッグコンソールのサンプル。
    /// </summary>
    [Alias("DebugConsole")]
    public class SampleDebugConsole : ILogHandler
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public SampleDebugConsole()
        {
            // Register this to Logger.
            Logger.RegisterLogHandler(this);
        }

        /// <summary>
        /// Called when messages being send to the logger.
        /// </summary>
        /// <param name="destination">The output destination.</param>
        /// <param name="level">The log level.</param>
        /// <param name="message">The message to output.</param>
        public void Log(IEnumerable<string> destination, LogLevels level, string message)
        {
            // Output log!
            Console.WriteLine("SampleDebugConsole : {0} - {1}", level.ToString(), message);
        }
    }
}
