﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.Manager
{
    /// <summary>
    /// エミッターカスタムシェーダー設定情報.
    /// </summary>
    public class EmitterCustomShaderSettingInfo
    {
        /// <summary>
        /// .csファイル名.
        /// </summary>
        public string DataModelFileName { get; set; }

        /// <summary>
        /// .xamlフルファイルパス
        /// </summary>
        public string XamlFullFilepath { get; set; }

        /// <summary>
        /// バーテックスシェーダパス
        /// </summary>
        public List<string> VertexShaderPaths { get; set; }

        /// <summary>
        /// フラグメントシェーダパス
        /// </summary>
        public List<string> FragmentShaderPaths { get; set; }

        /// <summary>
        /// キャプション
        /// </summary>
        public string Caption { get; set; }

        /// <summary>
        /// コンバート情報ファイル名.
        /// </summary>
        public string ConversionInfoFileName { get; set; }
    }
}
