﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 履歴式ストライプ
    /// </summary>
    [Serializable]
    public class StripeHistoryUserData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public StripeHistoryUserData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumDivisions = 0;
            this.StripeLength = 60;
            this.SliceLength = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 1.0f;
            this.DirInterpolation = 1.0f;
        }

        /// <summary>
        /// 計算方式
        /// </summary>
        [DataModelPropertyGuid("62faa436-3421-470d-9a04-757870fc92f9")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従
        /// </summary>
        [DataModelPropertyGuid("f4cbc563-01fb-425a-bf3a-c6bc32257b25")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプション
        /// </summary>
        [DataModelPropertyGuid("78eb17c3-d7bb-4d0e-962d-a251328139f7")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリング
        /// </summary>
        [DataModelPropertyGuid("b297e0c9-579c-40fe-9269-80e67ca576f4")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 分割数
        /// </summary>
        [DataModelPropertyGuid("3a5acd33-60b3-4150-b69a-d5dee9eb7811")]
        public int NumDivisions { get; set; }

        /// <summary>
        /// 履歴数(ストライプの長さ)
        /// </summary>
        [DataModelPropertyGuid("b97b8357-3f6a-41cc-8b56-16bfa52fd008")]
        public int StripeLength { get; set; }

        /// <summary>
        /// 履歴ポリゴン化の間隔
        /// </summary>
        [DataModelPropertyGuid("bb2d38be-cc0a-471b-b1e2-3f7c8f55f37f")]
        public int SliceLength { get; set; }

        /// <summary>
        /// 先端α
        /// </summary>
        [DataModelPropertyGuid("6f2d00ad-69ed-4aa6-8f03-7efc8a00740a")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端α
        /// </summary>
        [DataModelPropertyGuid("de036dac-4fcd-48f1-8d25-395652bc7ef4")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータ
        /// </summary>
        [DataModelPropertyGuid("6684d5cc-846d-429f-8abb-437eb1538d35")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率
        /// </summary>
        [DataModelPropertyGuid("7bfa4b22-8a61-4748-bc02-f73d657949c3")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// ストライプタイプアイテム.
        ///
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("66b71722-fa76-4905-96e5-0ade69330e48")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("ビルボードストライプ", 0),
                    new ComboBoxItemType("エミッタ行列ストライプ", 1),
                    new ComboBoxItemType("エミッタの上下に伸ばす", 2),
                };

            }
        }

        /// <summary>
        /// オプションタイムアイテム.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("1287b5c8-af4b-46c2-9d98-0176dedb55de")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("クロス", 1),
                };
            }
        }

        /// <summary>
        /// テクスチャ座標タイプアイテム.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("ba6723f2-4880-4579-88c4-5f972dcadffd")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("全て貼る", 0),
                    new ComboBoxItemType("描画範囲に合わせて貼る", 1),
                };
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as StripeHistoryUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.StripeLength = srcDataModel.StripeLength;
            this.SliceLength = srcDataModel.SliceLength;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;

            return true;
        }
    }
}
