﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/ランダムタブデータです。
    /// </summary>
    [Serializable]
    public class RandomData : FieldDataBase
    {
        /// <summary>
        /// ランダムグループデータです。
        /// </summary>
        private RandomParamData randomParamData = null;

        /// <summary>
        /// ランダム基本設定
        /// </summary>
        private RandomBasicSetting randomBasicSetting = null;

        /// <summary>
        /// 位相を統一
        /// </summary>
        private RandomUnifiedPhaseParam randomUnifiedPhaseParam = null;

        /// <summary>
        /// ランダム詳細設定
        /// </summary>
        private RandomDetailedOption randomDetailedOption = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomData() :
            base()
        {
        }

        /// <summary>
        /// ランダムグループデータです。
        /// </summary>
        [DataModelPropertyGuid("aef724c3-58be-45bd-8516-be3e2ef42972")]
        public RandomParamData RandomParamData
        {
            get { return this.GetDataModelFromField(ref this.randomParamData, false); }
            set { this.SetDataModelToField(ref this.randomParamData, value); }
        }

        /// <summary>
        /// ランダム基本設定
        /// </summary>
        [DataModelPropertyGuid("a38fed82-41d8-4d0b-97cf-da2dbf134838")]
        public RandomBasicSetting RandomBasicSetting
        {
            get { return this.GetDataModelFromField(ref this.randomBasicSetting, false); }
            set { this.SetDataModelToField(ref this.randomBasicSetting, value); }
        }

        /// <summary>
        /// 位相を統一
        /// </summary>
        [DataModelPropertyGuid("5cc15027-4738-46a4-9fb5-939bafe3f782")]
        public RandomUnifiedPhaseParam RandomUnifiedPhaseParam
        {
            get { return this.GetDataModelFromField(ref this.randomUnifiedPhaseParam, false); }
            set { this.SetDataModelToField(ref this.randomUnifiedPhaseParam, value); }
        }

        /// <summary>
        /// ランダム詳細設定
        /// </summary>
        [DataModelPropertyGuid("b5740c2e-fbb5-45b6-ba2a-30fa4c8d7f68")]
        public RandomDetailedOption RandomDetailedOption
        {
            get { return this.GetDataModelFromField(ref this.randomDetailedOption, false); }
            set { this.SetDataModelToField(ref this.randomDetailedOption, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as RandomData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomParamData = srcDataModel.RandomParamData;
            this.RandomBasicSetting = srcDataModel.RandomBasicSetting;
            this.RandomUnifiedPhaseParam = srcDataModel.RandomUnifiedPhaseParam;
            this.RandomDetailedOption = srcDataModel.RandomDetailedOption;

            return true;
        }
    }
}
