﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/シンプルコリジョンデータです。
    /// </summary>
    [Serializable]
    public class CollisionParamData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CollisionParamData() :
            base()
        {
            this.ActionType = 1;
            this.IsWorld = false;
            this.UseSharedPlane = false;
            this.Coordinate = 0.0f;
            this.BounceRate = 0.0f;
            this.BounceCount = -1;
            this.FrictionCoefficient = 1.0f;
        }

        /// <summary>
        /// ヒット時の挙動.
        /// </summary>
        [DataModelPropertyGuid("4fb16e75-0da9-4e54-8bb1-5472640b5468")]
        public int ActionType { get; set; }

        /// <summary>
        /// 座標系.
        /// </summary>
        [DataModelPropertyGuid("360c5cce-e9fe-48f7-9b15-fdf32fcf5e73")]
        public bool IsWorld { get; set; }

        /// <summary>
        /// 共有平面を利用する.
        /// </summary>
        [DataModelPropertyGuid("52cf4a84-78f1-41e8-a961-7efa5fcf783b")]
        public bool UseSharedPlane { get; set; }

        /// <summary>
        /// コリジョン面Y座標.
        /// </summary>
        [DataModelPropertyGuid("5c238714-2e4a-4ab9-a377-ed42a8b468d8")]
        public float Coordinate { get; set; }

        /// <summary>
        /// 反射率.
        /// </summary>
        [DataModelPropertyGuid("01b198b1-99da-4d40-b3e6-4e28781687d9")]
        public float BounceRate { get; set; }

        /// <summary>
        /// 反射回数.
        /// </summary>
        [DataModelPropertyGuid("bc304eef-4bc7-4751-9d23-4796899106ae")]
        public int BounceCount { get; set; }

        /// <summary>
        /// 摩擦係数.
        /// </summary>
        [DataModelPropertyGuid("cd9b3814-7c56-4473-a6c1-23c7d46e24c3")]
        public float FrictionCoefficient { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CollisionParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ActionType = srcDataModel.ActionType;
            this.IsWorld = srcDataModel.IsWorld;
            this.UseSharedPlane = srcDataModel.UseSharedPlane;
            this.Coordinate = srcDataModel.Coordinate;
            this.BounceRate = srcDataModel.BounceRate;
            this.BounceCount = srcDataModel.BounceCount;
            this.FrictionCoefficient = srcDataModel.FrictionCoefficient;

            return true;
        }
    }
}
