﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// スケールのパーティクル時間アニメーションデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleAnimationCurveData : DataModelBase
    {
        /// <summary>
        /// アニメーションテーブルです
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleAnimationCurveData() :
            base()
        {
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// アニメーションテーブルです
        /// </summary>
        [DataModelPropertyGuid("f655bd21-a7e6-45c4-998d-429c3ef2a2b0")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("2b91f6cc-4d36-4374-94e9-b2bc7c7b3669")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("0d2450b0-e942-434b-bbda-7aca685b6c85")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("67e29ba6-93d6-42d9-8e99-b2a41b9329ea")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterScaleAnimationCurveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
