﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブ/スケールアニメーショングループデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleAdditionalAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleAdditionalAnimationData() :
            base()
        {
            this.EnableScaleVelAddY = false;
            this.ScaleVelAddY = 0.0f;
        }

        /// <summary>
        /// スケールYへの速度加算をON/OFFします。
        /// </summary>
        [DataModelPropertyGuid("ab943196-7e5b-4bf1-bee5-a00d30cfec7a")]
        public bool EnableScaleVelAddY { get; set; }

        /// <summary>
        /// 速度をYスケールに加算.
        /// </summary>
        [DataModelPropertyGuid("3c003fd6-0c70-4ffc-b375-6888c1462e5e")]
        public float ScaleVelAddY { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterScaleAdditionalAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableScaleVelAddY = srcDataModel.EnableScaleVelAddY;
            this.ScaleVelAddY = srcDataModel.ScaleVelAddY;

            return true;
        }
    }
}
