﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転軸Zグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationZData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationZData() :
            base()
        {
            this.InitialRotation = 0.0f;
            this.InitialRotationRandom = 0.0f;
            this.EnableRotationRandom = false;
            this.RotationSpeed = 0.0f;
            this.RotationSpeedRandom = 0.0f;
        }

        /// <summary>
        /// 初期回転(Z軸)です.
        /// </summary>
        [DataModelPropertyGuid("39fb86ff-8c37-4e03-a36c-cab1fd26803b")]
        public float InitialRotation { get; set; }

        /// <summary>
        /// 回転のランダム幅(Z軸)です.
        /// </summary>
        [DataModelPropertyGuid("12783381-edfc-414e-afc9-32f87f0bc5da")]
        public float InitialRotationRandom { get; set; }

        /// <summary>
        /// 回転方向ランダム(Z軸)です.
        /// </summary>
        [DataModelPropertyGuid("3994a931-d120-492e-8241-34d8716aa150")]
        public bool EnableRotationRandom { get; set; }

        /// <summary>
        /// 回転速度(Z軸)です.
        /// </summary>
        [DataModelPropertyGuid("fe6b5953-01f4-4883-9e66-aad447c1ce7f")]
        public float RotationSpeed { get; set; }

        /// <summary>
        /// 回転速度のランダム幅(Z軸)です.
        /// </summary>
        [DataModelPropertyGuid("846ff311-ffb4-4e32-be31-c5013aa46e3d")]
        public float RotationSpeedRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterRotationZData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.InitialRotation = srcDataModel.InitialRotation;
            this.InitialRotationRandom = srcDataModel.InitialRotationRandom;
            this.EnableRotationRandom = srcDataModel.EnableRotationRandom;
            this.RotationSpeed = srcDataModel.RotationSpeed;
            this.RotationSpeedRandom = srcDataModel.RotationSpeedRandom;

            return true;
        }
    }
}
