﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// アニメーションのループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterColorAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterColorAnimationData() :
            base()
        {
        }

        /// <summary>
        /// ループするか
        /// </summary>
        [DataModelPropertyGuid("0b4bd0be-cd0b-44f0-ab33-01fad2ccdd78")]
        public bool EnableLoop { get; set; }

        /// <summary>
        /// 補間方式です
        /// </summary>
        [DataModelPropertyGuid("9be1e938-e3a4-448e-984f-44837cf7eefd")]
        public int InterpolationMethod { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterEmitterColorAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableLoop = srcDataModel.EnableLoop;
            this.InterpolationMethod = srcDataModel.InterpolationMethod;

            return true;
        }
    }
}
