﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/カラー計算グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorCalculationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorCalculationData() :
            base()
        {
            this.ColorScale = 1.0f;
            this.ColorAlphaFixFlag = false;
        }

        /// <summary>
        /// カラースケール.
        /// </summary>
        [DataModelPropertyGuid("ce747b39-a8df-4d5b-a30f-b361c0d41125")]
        public float ColorScale { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("009a0616-251e-4213-9d61-c973d9c3db9d")]
        public bool ColorAlphaFixFlag { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterColorCalculationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ColorScale = srcDataModel.ColorScale;
            this.ColorAlphaFixFlag = srcDataModel.ColorAlphaFixFlag;

            return true;
        }
    }
}
