﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The binary header data for emitter.
    /// </summary>
    [Serializable]
    public class EmitterBinaryHeaderData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBinaryHeaderData() :
            base()
        {
        }

        /// <summary>
        /// Get tag 0 of the binary header.
        /// </summary>
        [DataModelPropertyGuid("a4a3d677-b454-4387-9c42-4aca9b81dcd0")]
        public byte Tag0
        {
            get
            {
                return (byte)'E';
            }
        }

        /// <summary>
        /// Get tag 1 of the binary header.
        /// </summary>
        [DataModelPropertyGuid("7dc15791-b225-40a0-9f3f-87d541f32de5")]
        public byte Tag1
        {
            get
            {
                return (byte)'M';
            }
        }

        /// <summary>
        /// Get tag 2 for the binary header.
        /// </summary>
        [DataModelPropertyGuid("ffe50f89-a7fa-45f4-9a50-9c5c5018faa0")]
        public byte Tag2
        {
            get
            {
                return (byte)'T';
            }
        }

        /// <summary>
        /// Get tag 3 for the binary header.
        /// </summary>
        [DataModelPropertyGuid("565b9202-9679-4e71-9c44-24b230c909c7")]
        public byte Tag3
        {
            get
            {
                return (byte)'R';
            }
        }

        /// <summary>
        /// Get the next emitter data in the emitter list of the parent emitter set.
        /// </summary>
        [DataModelPropertyGuid("8b9c7f42-853d-42fb-b6e7-d85bdfce323e")]
        public DataModelBase Next
        {
            get
            {
                var myEmitter = this.Parent as EmitterData;
                if (myEmitter == null)
                {
                    return null;
                }

                IEnumerable<EmitterData> emitters = null;
                if (myEmitter.Parent is EmitterSetData)
                {
                    emitters = ((EmitterSetData)myEmitter.Parent).EmitterList;
                }
                else if (myEmitter.Parent is EmitterData)
                {
                    emitters = ((EmitterData)myEmitter.Parent).EmitterList;
                }

                bool found = false;
                foreach (var emitter in emitters)
                {
                    if (found == false &&
                        object.ReferenceEquals(emitter, myEmitter) == true)
                    {
                        found = true;
                    }
                    else if (found == true)
                    {
                        return emitter;
                    }
                }

                return null;
            }
        }

        /// <summary>
        /// Get the first child emitter data.
        /// </summary>
        [DataModelPropertyGuid("2b44ee8b-3cc7-45e8-aee8-8cf13082c77e")]
        public DataModelBase Child
        {
            get
            {
                var emitter = this.Parent as EmitterData;
                if (emitter == null ||
                    emitter.EmitterList.Count <= 0)
                {
                    return null;
                }

                return emitter.EmitterList[0];
            }
        }

        /// <summary>
        /// Get the first data model in the sub tree.
        /// </summary>
        [DataModelPropertyGuid("d7807004-5bce-46f5-ac58-f9cc49392104")]
        public DataModelBase Sub
        {
            get
            {
                // Return null for now.
                // This should be implemented after the runtime is done.
                return null;
            }
        }

        /// <summary>
        /// Get the offset to the binary data.
        /// </summary>
        [DataModelPropertyGuid("794b3632-a7c6-430f-be22-693a76b3cde2")]
        public uint BinaryDataOffset
        {
            get
            {
                // The size of the binary header data.
                return 32;
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterBinaryHeaderData;
            if (srcDataModel == null)
            {
                return false;
            }


            return true;
        }
    }
}
