﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Windows.Documents;
using System.Xml;
using System.Xml.Schema;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using System;
using System.Xml.Serialization;
using NWCore.src.Remake.DataModel.DataModels;
using NWCore.src.Remake.DataModel.DataModels.Emitter;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムアクションタブデータです.

    /// </summary>
    [Serializable]
    public class CustomActionData : DataModelBase, IXmlSerializable
    {
        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting0 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting1 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting2 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting3 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting4 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting5 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting6 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData setting7 = null;

        /// <summary>
        ///
        /// </summary>
        private CustomActionSettingData defaultSetting = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionData() :
            base()
        {
            this.SelectedSettingIndex  = 0;
        }

        /// <summary>
        /// 選択中セッティングインデックスです.
        /// </summary>
        [DataModelPropertyGuid("2ca921d2-cb8b-4267-a794-4c8c7d4cbbcb")]
        public int SelectedSettingIndex  { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("d34f73d7-0506-40bf-9fdb-91b549ea62c4")]
        public CustomActionSettingData Setting0
        {
            get { return this.setting0; }
            set { this.setting0 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("a1b2e967-a11a-4bb8-97ae-6dcdbd00d3d2")]
        public CustomActionSettingData Setting1
        {
            get { return this.setting1; }
            set { this.setting1 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("a24c1425-ac99-4477-96d3-5a3e522ff8df")]
        public CustomActionSettingData Setting2
        {
            get { return this.setting2; }
            set { this.setting2 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("abe7f6d5-98e7-4d76-aeed-b02ca11c4a06")]
        public CustomActionSettingData Setting3
        {
            get { return this.setting3; }
            set { this.setting3 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("1d6f37cf-e797-495b-a13b-8e2fbd5dd121")]
        public CustomActionSettingData Setting4
        {
            get { return this.setting4; }
            set { this.setting4 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("c7186aa2-2075-4697-b95c-e072b4f6c764")]
        public CustomActionSettingData Setting5
        {
            get { return this.setting5; }
            set { this.setting5 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("eeb64f26-b070-4a8f-93a3-26f022d5b7cf")]
        public CustomActionSettingData Setting6
        {
            get { return this.setting6; }
            set { this.setting6 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("f07d6511-1c5f-4c1d-9a42-3b866655b6cc")]
        public CustomActionSettingData Setting7
        {
            get { return this.setting7; }
            set { this.setting7 = value; }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("F8AD707B-3273-4227-A317-CD0C786185F9")]
        public CustomActionSettingData DefaultSetting
        {
            get { return this.defaultSetting; }
            set { this.defaultSetting = value; }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CustomActionData;
            if (srcDataModel == null)
            {
                return false;
            }

            this.SelectedSettingIndex  = srcDataModel.SelectedSettingIndex;
            this.Setting0 = srcDataModel.Setting0;
            this.Setting1 = srcDataModel.Setting1;
            this.Setting2 = srcDataModel.Setting2;
            this.Setting3 = srcDataModel.Setting3;
            this.Setting4 = srcDataModel.Setting4;
            this.Setting5 = srcDataModel.Setting5;
            this.Setting6 = srcDataModel.Setting6;
            this.Setting7 = srcDataModel.Setting7;
            this.DefaultSetting = srcDataModel.DefaultSetting;

            return true;
        }

        public XmlSchema GetSchema()
        {
            // NO RETURN
            return null;
        }

        public void ReadXml(XmlReader reader)
        {
            // DO NOTHING
        }

        public void WriteXml(XmlWriter writer)
        {
            writer.WriteElementString("SelectedSettingIndex", this.SelectedSettingIndex.ToString("D"));

            if (this.DefaultSetting != null)
            {
                WriteSetting(writer, this.DefaultSetting);
            }

            writer.WriteStartElement("Settings");
            writer.WriteAttributeString("Count", "8");

            var settings = new List<CustomActionSettingData>
            {
                this.Setting0,
                this.Setting1,
                this.Setting2,
                this.Setting3,
                this.Setting4,
                this.Setting5,
                this.Setting6,
                this.Setting7,
            };

            foreach (var setting in settings)
            {
                WriteSetting(writer, setting);
            }

            writer.WriteEndElement();
        }

        private void WriteSetting(XmlWriter writer, CustomActionSettingData setting)
        {
            var convertData = setting as CustomActionConvertingData;
            if (convertData == null)
            {
                writer.WriteStartElement("CustomActionSettingData");
                writer.WriteAttributeString("xsi:nil", bool.TrueString);
                writer.WriteEndElement();
                return;
            }

            writer.WriteStartElement(convertData.Name);
            writer.WriteAttributeString("xsi:type", convertData.Name);

            writer.WriteElementString("Flag0", convertData.Flags.ToString("D"));

            for (int i = 0; i < convertData.IntParams.Count; ++i)
            {
                writer.WriteElementString(
                    string.Format("IntParam{0}", i),
                    convertData.IntParams[i].ToString("D"));
            }

            for (int i = 0; i < convertData.FloatParams.Count; ++i)
            {
                writer.WriteElementString(
                    string.Format("FloatParam{0}", i),
                    convertData.FloatParams[i].ToString());
            }

            writer.WriteEndElement();
        }
    }
}
