﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModel.Attributes
{
    /// <summary>
    /// Custom attribute for assigning Guid for a data model property.
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, AllowMultiple = false, Inherited = false)]
    public class DataModelPropertyGuidAttribute : System.Attribute
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="guidStr">The string representation of the Guid.</param>
        public DataModelPropertyGuidAttribute(string guidStr)
        {
            this.Guid = Guid.Parse(guidStr);
        }

        /// <summary>
        /// Get the Guid for the data model property.
        /// </summary>
        public Guid Guid { get; private set; }
    }
}
