﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Text;

namespace NWCore.Protocols
{
    /// <summary>BaseMessagePacket</summary>
    public abstract class BaseMessagePacket
    {
        /// <summary>Number of loops needed for processing the packet.</summary>
        public virtual int NumProcessLoops
        {
            get { return 1; }
        }

        /// <summary>後に続く配列の長さ</summary>
        public abstract int ArrayLength{	get;	}

        /// <summary>CreateStructPacket</summary>
        public virtual BaseStructPacket CreateStructPacket()
        {
            return null;
        }

        /// <summary>Read</summary>
        public abstract void Read(Protocol4FReader reader);

        /// <summary>Write</summary>
        public abstract void Write(Protocol4FWriter writer);
    }
}
