﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// Field mask
    /// </summary>
    public class FieldMask : ISettable
    {
        /// <summary>
        /// Get or set the flags.
        /// </summary>
        public uint Flag
        {
            get
            {
                uint ret = 0;

                if (Random == true)
                    ret |= (1 << 0);
                if (Magnet == true)
                    ret |= (1 << 1);
                if (Spin == true)
                    ret |= (1 << 2);
                if (Collision == true)
                    ret |= (1 << 3);
                if (Convergence == true)
                    ret |= (1 << 4);
                if (PosAdd == true)
                    ret |= (1 << 5);
                if (CurlNoise == true)
                    ret |= (1 << 6);

                return ret;
            }
            set
            {
                Random = (0 != (value & (1 << 0)));
                Magnet = (0 != (value & (1 << 1)));
                Spin = (0 != (value & (1 << 2)));
                Collision = (0 != (value & (1 << 3)));
                Convergence = (0 != (value & (1 << 4)));
                PosAdd = (0 != (value & (1 << 5)));
                CurlNoise = (0 != (value & (1 << 6)));
            }
        }

        /// <summary>
        /// ISettable用
        /// </summaey>
        public void Set(object source)
        {
            Ensure.Argument.True(source is FieldMask);
            this.Flag = (source as FieldMask).Flag;
        }

        /// <summary>
        /// ランダムを使用するか？
        /// </summary>
        public bool Random { get; set; }

        /// <summary>
        /// 磁力を使用するか？
        /// </summary>
        public bool Magnet { get; set; }

        /// <summary>
        /// スピンを使用するか？
        /// </summary>
        public bool Spin { get; set; }

        /// <summary>
        /// 収束を使用するか？
        /// </summary>
        public bool Convergence { get; set; }

        /// <summary>
        /// 位置に加算を使用するか？
        /// </summary>
        public bool PosAdd { get; set; }

        /// <summary>
        /// コリジョンを使用するか？
        /// </summary>
        public bool Collision { get; set; }

        /// <summary>
        /// カールノイズを使用するか？
        /// </summary>
        public bool CurlNoise { get; set; }
    }
}
