﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.Foundation.Render.Renderable;

using EffectMaker.UIControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;

namespace EffectMaker.DataModelMaker.UIControls.DataModelView.Runtime
{
    /// <summary>
    /// Renderable class for rendering a runtime data model list item.
    /// </summary>
    internal class RuntimeDataModelListItemRenderable : DataModelListItemRenderable
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="owner">The owner of the view.</param>
        public RuntimeDataModelListItemRenderable(DataModelListViewport owner) :
            base(owner)
        {
            this.Size = new SizeF(0.0f, 25.0f);

            // Set up binding.
            this.Bindings.Add(new Binder(this, "Namespace", "Namespace"));
            this.Bindings.Add(new Binder(this, "DataModelName", "Name"));
            this.Bindings.Add(new Binder(this, "Description", "Description"));
        }

        /// <summary>
        /// Get or set the namespace of the data model class.
        /// </summary>
        public string Namespace { get; set; }

        /// <summary>
        /// Get or set the class name of the data model.
        /// </summary>
        public string DataModelName { get; set; }

        /// <summary>
        /// Get or set the data model description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Render the item's foreground.
        /// </summary>
        /// <param name="g">The graphics object for rendering.</param>
        protected override void DrawForeground(Graphics g)
        {
            var rect = this.TransformedBounds;

            using (var strFormat = new StringFormat())
            {
                // Middle-left alignment.
                strFormat.Alignment = StringAlignment.Near;
                strFormat.LineAlignment = StringAlignment.Center;

                strFormat.Trimming = StringTrimming.EllipsisPath;

                string str = this.DataModelName;
                if (string.IsNullOrEmpty(this.Namespace) == false)
                {
                    str = this.Namespace + "::" + str;
                }

                g.DrawString(
                    str,
                    DataModelListItemRenderable.DataModelNameFont,
                    Brushes.DarkBlue,
                    rect,
                    strFormat);
            }
        }
    }
}
