﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.DataModelMaker.Core.Converters;
using EffectMaker.DataModelMaker.Core.Definitions;

namespace EffectMaker.DataModelMaker.UIControls.ConversionView
{
    /// <summary>
    /// Interface for the destination connectible objects.
    /// </summary>
    internal interface IDestinationConnectible : IConnectible
    {
        /// <summary>
        /// Enumerate the Guid of the connected sources.
        /// </summary>
        IEnumerable<Guid> ConnectedSources { get; }

        /// <summary>
        /// Enumerate connections that connect to the connectible.
        /// </summary>
        IEnumerable<ConnectionRenderable> Connections { get; }

        /// <summary>
        /// Get or set the converter for converting the data from the source connectible.
        /// </summary>
        ConverterInfo Converter { get; set; }

        /// <summary>
        /// Add a new connection source.
        /// </summary>
        /// <param name="sourceGuid">The Guid of the connection source.</param>
        void AddConnectionSource(Guid sourceGuid);

        /// <summary>
        /// Remove existing connection sources.
        /// </summary>
        /// <param name="sourceGuidList">The list of Guid of the connection sources.</param>
        void RemoveConnectionSources(IEnumerable<Guid> sourceGuidList);
    }
}
