﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Drawing;

namespace EffectMaker.DataModelMaker.UIControls.ConversionView
{
    /// <summary>
    /// Interface for connectible objects.
    /// </summary>
    internal interface IConnectible
    {
        /// <summary>
        /// Get the connector.
        /// </summary>
        ConnectorRenderable Connector { get; }

        /// <summary>
        /// Get the location of the connector.
        /// </summary>
        PointF ConnectorLocation { get; }

        /// <summary>
        /// Get the transformed location of the connector.
        /// </summary>
        PointF TransformedConnectorLocation { get; }

        /// <summary>
        /// Get the width of the item;
        /// </summary>
        float Width { get; }

        /// <summary>
        /// Get the height of the item.
        /// </summary>
        float Height { get; }

        /// <summary>
        /// Get the description of the connectible.
        /// </summary>
        string Description { get; }

        /// <summary>
        /// Get string as the type of the value.
        /// </summary>
        string ValueType { get; }

        /// <summary>
        /// Get the name of the connectible.
        /// </summary>
        string DisplayName { get; }

        /// <summary>
        /// Get the flag indicating whether the connection of the connectible is set.
        /// </summary>
        bool IsConnectionSet { get; }

        /// <summary>
        /// Determine if the specified target can be connected to this connectible item.
        /// </summary>
        /// <param name="target">The connection target.</param>
        /// <returns>True if can connect.</returns>
        bool CanConnect(IConnectible target);
    }
}
