﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Windows.Forms;

using EffectMaker.DataModelMaker.UIControls.DataModelEditor;
using EffectMaker.DataModelMaker.UIControls.DataModelPropertyEditor;

using EffectMaker.Foundation.Render.ObjectPicking;
using EffectMaker.Foundation.Render.Renderable;
using EffectMaker.Foundation.Render.ScrollBar;

using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.DataModelMaker.UIControls.BinaryDataView
{
    /// <summary>
    /// Control class for rendering the data model relation view.
    /// </summary>
    public partial class BinaryDataView : UserControl
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public BinaryDataView()
        {
            // Enable double buffer.
            this.DoubleBuffered = true;
            this.BackColor = Color.White;

            this.InitializeComponent();
        }

        /// <summary>
        /// Event triggered when left split panel splitter moved.
        /// </summary>
        public event SplitterEventHandler LeftSplitterMoved = null;

        /// <summary>
        /// Event triggered when right split panel splitter moved.
        /// </summary>
        public event SplitterEventHandler RightSplitterMoved = null;

        /// <summary>
        /// Get or set the splitter distance of the left split panel.
        /// </summary>
        public int LeftSplitterDistance
        {
            get { return this.mainSplitPanel.SplitterDistance; }
            set { this.mainSplitPanel.SplitterDistance = value; }
        }

        /// <summary>
        /// Get or set the splitter distance of the right split panel.
        /// </summary>
        public int RightSplitterDistance
        {
            get { return this.rightSplitContainer.SplitterDistance; }
            set { this.rightSplitContainer.SplitterDistance = value; }
        }

        /// <summary>
        /// Get or set the data context.
        /// </summary>
        public object DataContext
        {
            get
            {
                return this.binaryDataListPanel.DataContext;
            }

            set
            {
                this.binaryDataListPanel.DataContext = value;
                this.binaryInfoPanel.DataContext = value;
                this.fieldGroupTargetListPanel.DataContext = value;
            }
        }

        /// <summary>
        /// Handle SplitterMoved event for the left split panel.
        /// </summary>
        /// <param name="sender">The sender of the event.</param>
        /// <param name="e">The event arguments.</param>
        private void OnLeftSlitPanelSplitterMoved(object sender, SplitterEventArgs e)
        {
            if (this.LeftSplitterMoved != null)
            {
                this.LeftSplitterMoved(this, e);
            }
        }

        /// <summary>
        /// Handle SplitterMoved event for the right split panel.
        /// </summary>
        /// <param name="sender">The sender of the event.</param>
        /// <param name="e">The event arguments.</param>
        private void OnRightSlitPanelSplitterMoved(object sender, SplitterEventArgs e)
        {
            if (this.RightSplitterMoved != null)
            {
                this.RightSplitterMoved(this, e);
            }
        }
    }
}
