﻿::=============================================================================
::  Effect2.0 DataModelMakerの出力コードの適用バッチ
::  2014.03.12-
::=============================================================================

@echo off

::=============================================================================
::パスを設定
set NINTENDOWARE_DIR=..\..\..\..\..\..\..\
set EFFECT_MAKER_DIR=%NINTENDOWARE_DIR%Sources\Tools\Graphics\EffectMaker\
set CONVERT_DIR=%EFFECT_MAKER_DIR%Logic\DataModelLogic\BinaryConversionInfo
set ADDINS_DIR=%EFFECT_MAKER_DIR%Addins
set VERSIONED_DIR=%EFFECT_MAKER_DIR%Model\DataModel.Specifics\DataModels\Versioned
set NONVERSIONED_DIR=%EFFECT_MAKER_DIR%Model\DataModel.Specifics\DataModels\NonVersioned

::=============================================================================
::エディタデータモデル
copy ConverterSourceFiles\EmitterSetBinaryConversionInfo.cs %CONVERT_DIR%
copy ConverterSourceFiles\ModelBinaryConversionInfo.cs %CONVERT_DIR%
copy ConverterSourceFiles\PreviewBinaryConversionInfo.cs %CONVERT_DIR%
copy ConverterSourceFiles\ViewerBinaryConversionInfo.cs %CONVERT_DIR%

copy ConverterSourceFiles\ModelAutoMoveBinaryConversionInfo.cs %ADDINS_DIR%
copy ConverterSourceFiles\ModelTransformBinaryConversionInfo.cs %ADDINS_DIR%
copy ConverterSourceFiles\StripeComplexBinaryConversionInfo.cs %ADDINS_DIR%
copy ConverterSourceFiles\StripeHistoryBinaryConversionInfo.cs %ADDINS_DIR%
copy ConverterSourceFiles\StripeSuperBinaryConversionInfo.cs %ADDINS_DIR%

::EP~BinaryConversionInfo.csはAddinsにコピー（エミッタプラグイン）
copy ConverterSourceFiles\EP*BinaryConversionInfo.cs %ADDINS_DIR%

xcopy /s /e /y EditorDataModels\Versioned %VERSIONED_DIR%

copy EditorDataModels\NonVersioned\CustomAction\*.* %NONVERSIONED_DIR%\CustomAction\*.*
copy EditorDataModels\NonVersioned\EmitterExtParams\*.* %NONVERSIONED_DIR%\EmitterExtParams\*.*
copy EditorDataModels\NonVersioned\Emitter\*.* %NONVERSIONED_DIR%\Emitter\*.*
copy EditorDataModels\NonVersioned\UserData\*.* %ADDINS_DIR%


::=============================================================================
::ランタイムデータモデル
copy RuntimeDataModels\vfx_Data.h %NINTENDOWARE_DIR%Include\nn\vfx
copy RuntimeDataModels\vfx_ViewerData.h %NINTENDOWARE_DIR%Include\nn\vfx\viewer

cscript vfxtoeft2.vbs RuntimeDataModels\vfx_Data.h RuntimeDataModels\eft2_Data.h
copy RuntimeDataModels\eft2_Data.h %NINTENDOWARE_DIR%Include\nw\eft

cscript vfxtoeft2.vbs RuntimeDataModels\vfx_ViewerData.h RuntimeDataModels\eftvw2_Data.h
copy RuntimeDataModels\eftvw2_Data.h %NINTENDOWARE_DIR%Include\nw\eft

::=============================================================================
::XPath テーブル
copy XPathTable\XPathTable.xml %EFFECT_MAKER_DIR%Addins\XPathTables\MainTable.xml


::=============================================================================

@echo on

pause
