﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Reflection;

namespace EffectMaker.DataModelMaker.Core.Template
{
    /// <summary>
    /// Enum for template token types.
    /// </summary>
    public enum TemplateTokenTypes
    {
        /// <summary>A token that represents plain text.</summary>
        PlainText,

        /// <summary>A token that represents a template tag.</summary>
        TemplateTag,

        /// <summary>A token that represents a list of template entries.</summary>
        EntryList,
    }

    /// <summary>
    /// Class for holding a "token" in the templates.
    /// A token can be a plain text or a property info for getting
    /// definition value through reflection.
    /// </summary>
    public class TemplateToken
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public TemplateToken()
        {
            this.Type = TemplateTokenTypes.TemplateTag;
            this.Name = null;
            this.PropertyInfo = null;
            this.PlainText = null;
        }

        /// <summary>
        /// Get or set the template token type.
        /// </summary>
        public TemplateTokenTypes Type { get; set; }

        /// <summary>
        /// Get or set the name of the token.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Get or set the property info to get value from.
        /// </summary>
        public PropertyInfo PropertyInfo { get; set; }

        /// <summary>
        /// Get or set plain text.
        /// </summary>
        public string PlainText { get; set; }
    }
}
