﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace EffectMaker.DataModelMaker.Core.Definitions
{
    /// <summary>
    /// コード生成のための一時定義クラスです.
    /// </summary>
    public class BinaryConversionFieldInfoDefinition
    {
        /// <summary>
        /// コンストラクタです.
        /// Temporary class for generation of source code.
        /// </summary>
        public BinaryConversionFieldInfoDefinition()
        {
            this.Method      = "AddBinaryFieldDefinition";
            this.Converter   = "DefaultConverter";
            this.GuidList    = Guid.Empty.ToString("D");
            this.Owner       = string.Empty;
            this.CreateOwner = string.Empty;
            this.Struct      = "null";
            this.OutputName  = string.Empty;
            this.InputName   = string.Empty;
            this.ExSize      = 0;
            this.HasExData   = false;
        }

        /// <summary>
        /// メソッド名を設定/取得します.
        /// </summary>
        public string Method { get; set; }

        /// <summary>
        /// コンバータ名を設定/取得します.
        /// </summary>
        public string Converter { get; set; }

        /// <summary>
        /// Get or set the converter parameters.
        /// </summary>
        public string ConverterParams { get; set; }

        /// <summary>
        /// Guidリストを設定/取得します.
        /// </summary>
        public string GuidList { get; set; }

        /// <summary>
        /// データの所有者を設定/取得します.
        /// </summary>
        public string Owner { get; set; }

        /// <summary>
        /// オーナー生成処理を設定/取得します.
        /// </summary>
        public string CreateOwner { get; set; }

        /// <summary>
        /// 定義データが構造体の場合の文字列を設定/取得します.
        /// </summary>
        public string Struct { get; set; }

        /// <summary>
        /// 出力先の名前を設定/取得します.
        /// </summary>
        public string OutputName { get; set; }

        /// <summary>
        /// 入力元の名前を設定/取得します.
        /// </summary>
        public string InputName { get; set; }

        /// <summary>
        /// 固定サイズ・アライメントサイズを設定取得します.
        /// </summary>
        public int ExSize { get; set; }

        /// <summary>
        /// 固定サイズ・アライメントサイズを持つかどうか.
        /// </summary>
        public bool HasExData { get; set; }

        /// <summary>
        /// 送信挙動タイプ
        /// </summary>
        public string SendModificationType { get; set; }

        /// <summary>
        /// バイナリタグです.
        /// </summary>
        public string Tag { get; set; }
    }

    /// <summary>
    /// ファイル生成のための一時定義クラスです.
    /// </summary>
    public class BinaryConversionInfoDefinition
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public BinaryConversionInfoDefinition()
        {
            this.FileName           = string.Empty;
            this.RootDataModelName  = string.Empty;
            this.RootBinaryName     = string.Empty;
            this.FieldDefinitions   = new List<BinaryConversionFieldInfoDefinition>();
            this.Owner              = string.Empty;
        }

        /// <summary>
        /// ファイル名を設定/取得します.
        /// </summary>
        public string FileName { get; set; }

        /// <summary>
        /// ルートとなるデータモデル名を設定/取得します.
        /// </summary>
        public string RootDataModelName { get; set; }

        /// <summary>
        /// ルートとなるバイナリ名を設定/取得します.
        /// </summary>
        public string RootBinaryName { get; set; }

        /// <summary>
        /// オーナー名を設定/取得します.
        /// </summary>
        public string Owner { get; set; }

        /// <summary>
        /// ユーザーデータであるかどうか.
        /// </summary>
        public bool IsUserData { get; set; }

        /// <summary>
        /// フィールド定義を設定/取得します.
        /// </summary>
        public List<BinaryConversionFieldInfoDefinition> FieldDefinitions { get; set; }
    }

    /// <summary>
    /// クラス整理用の一時定義クラスです.
    /// </summary>
    public class BinaryDataGroupDefinition
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public BinaryDataGroupDefinition()
        {
            this.FileName = string.Empty;
            this.BinaryDatas = new List<BinaryDataDefinition>();
        }

        /// <summary>
        /// ファイル名です.
        /// </summary>
        public string FileName { get; set; }

        /// <summary>
        /// ユーザーデータであるかどうか.
        /// </summary>
        public bool IsUserData { get; set; }

        /// <summary>
        /// バイナリデータ定義です.
        /// </summary>
        public List<BinaryDataDefinition> BinaryDatas { get; set; }
    }
}
