﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.DataModelMaker.Core.Core
{
    /// <summary>
    /// The class that manages paths being used in the definitions.
    /// </summary>
    public static class PathManager
    {
        /// <summary>The dictionary that stores the export folder paths for editor data models.</summary>
        private static Dictionary<string, string> editorDataModelExportFolders =
            new Dictionary<string, string>();

        /// <summary>
        /// Get the editor data model export folder paths.
        /// </summary>
        public static IEnumerable<string> EditorDataModelExportFolders
        {
            get { return editorDataModelExportFolders.Select(it => it.Value); }
        }

        /// <summary>
        /// Add a export folder for editor data models.
        /// </summary>
        /// <param name="path">The relative path of the folder.</param>
        public static void AddEditorDataModelExportFolder(string path)
        {
            string lowerPath = path.ToLower();
            if (editorDataModelExportFolders.ContainsKey(lowerPath) == true)
            {
                return;
            }

            editorDataModelExportFolders.Add(lowerPath, path);
        }

        /// <summary>
        /// Clear all the registered editor data model export folder paths.
        /// </summary>
        public static void ClearEditorDataModelExportFolders()
        {
            editorDataModelExportFolders.Clear();
        }
    }
}
