﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Attributes;

namespace EffectMaker.DataModelMaker.Core
{
    /// <summary>
    /// Enum of access modifiers.
    /// </summary>
    public enum AccessModifiers
    {
        /// <summary>Public access modifier.</summary>
        [Alias("public")]
        Public,

        /// <summary>Protected access modifier.</summary>
        [Alias("protected")]
        Protected,

        /// <summary>Private access modifier.</summary>
        [Alias("private")]
        Private,
    }
}
