﻿// ========================================================================
// <copyright file="IRandom.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;

    /// <summary>
    /// 乱数を生成するインタフェースです。
    /// </summary>
    public interface IRandom : ISettable, ICloneable
    {
        /// <summary>
        /// 0からmaxValueまでの乱数をintで得ます。
        /// <remarks>0は含みますが、maxValueを含みません。</remarks>
        /// </summary>
        /// <param name="maxValue">乱数の最大値です。</param>
        /// <returns>0からmaxValueまでの乱数を返します。</returns>
        int Next(int maxValue);

        /// <summary>
        /// 0から1の乱数をfloatで得ます。
        /// <remarks>0は含みますが、1を含みません。</remarks>
        /// </summary>
        /// <returns>0から1の乱数を返します。</returns>
        float NextFloat();
    }
}
