﻿// ========================================================================
// <copyright file="IColor.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.ComponentModel;

    /// <summary>
    /// カラーのインターフェースです。
    /// </summary>
    public interface IColor : ISettable, ICloneable, INotifyPropertyChanged
    {
        /// <summary>
        /// R 取得します。
        /// </summary>
        float R { get; }

        /// <summary>
        /// G 取得します。
        /// </summary>
        float G { get; }

        /// <summary>
        /// B 取得します。
        /// </summary>
        float B { get; }

        /// <summary>
        /// A 取得または設定します。
        /// </summary>
        float A { get; set; }

        /// <summary>
        /// H を取得します。
        /// </summary>
        float H { get; }

        /// <summary>
        /// S を取得します。
        /// </summary>
        float S { get; }

        /// <summary>
        /// V を取得します。
        /// </summary>
        float V { get; }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="source">設定元のインスタンスです。</param>
        void Set(IColor source);
    }
}
