﻿// ========================================================================
// <copyright file="OrientedBoundingBoxXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// OBBクラスです。
    /// </summary>
    [CoupledType(typeof(OrientedBoundingBox))]
    public class OrientedBoundingBoxXml : ISettable
    {
        private const float DefaultSize = OrientedBoundingBox.DefaultSize;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OrientedBoundingBoxXml()
        {
            this.CenterPosition = new Vector3Xml();

            this.OrientationMatrix = new Matrix33Xml();
            this.OrientationMatrix.M00 = 1.0f;
            this.OrientationMatrix.M11 = 1.0f;
            this.OrientationMatrix.M22 = 1.0f;

            this.Size = new Vector3Xml(DefaultSize, DefaultSize, DefaultSize);
        }

        /// <summary>
        /// 中心位置を取得します。
        /// </summary>
        [OverwriteAttribute(OverwriteAttribute.KindType.Set)]
        public Vector3Xml CenterPosition { get; set; }

        /// <summary>
        /// 姿勢行列を取得します。
        /// <remarks>
        /// TODO:CreativeStudio内で生成されたデータについて、
        /// BoundingVolumeを更新するメソッドを準備する必要があります。
        /// </remarks>
        /// </summary>
        [OverwriteAttribute(OverwriteAttribute.KindType.Set)]
        public Matrix33Xml OrientationMatrix { get; set; }

        /// <summary>
        /// 姿勢行列座標空間におけるサイズを取得します。
        /// </summary>
        [OverwriteAttribute(OverwriteAttribute.KindType.Set)]
        public Vector3Xml Size { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            var sourceObb = source as OrientedBoundingBoxXml;
            Ensure.Argument.NotNull(sourceObb);

            this.CenterPosition.Set(sourceObb.CenterPosition);
            this.OrientationMatrix.Set(sourceObb.OrientationMatrix);
            this.Size.Set(sourceObb.Size);
        }
    }
}
