﻿// ========================================================================
// <copyright file="TextSerializedList.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.Collections.Generic;
    using System.Xml;
    using System.Xml.Schema;
    using System.Xml.Serialization;

    /// <summary>
    /// XML要素のテキストとして、シリアライズするリストです。
    /// </summary>
    /// <typeparam name="TValue">リスト要素の型です。</typeparam>
    public class TextSerializedList<TValue> : List<TValue>, IXmlSerializable
    {
        /// <summary>
        /// XMLスキーマを取得します。
        /// </summary>
        /// <returns>XMLスキーマです。</returns>
        public XmlSchema GetSchema()
        {
            return null;
        }

        /// <summary>
        /// オブジェクトの XML 表現からオブジェクトを生成します。
        /// </summary>
        /// <param name="reader">オブジェクトの逆シリアル化元である　XmlReader です。</param>
        public void ReadXml(XmlReader reader)
        {
            bool isEmptyElement = reader.IsEmptyElement;
            reader.ReadStartElement();
            if (isEmptyElement)
            {
                return;
            }

            string content = reader.ReadString();
            if (!string.IsNullOrEmpty(content))
            {
                Func<int, IList<TValue>> reserveHandler = delegate(int count)
                {
                    this.Capacity = count;
                    for (int i = 0; i < count; i++)
                    {
                        this.Add(default(TValue));
                    }

                    return this;
                };
                XmlSerializeUtility.SetCollectionByString(content, this, reserveHandler);
            }

            reader.ReadEndElement();
        }

        /// <summary>
        /// オブジェクトを XML 表現に変換します。
        /// </summary>
        /// <param name="writer">オブジェクトのシリアル化先の XmlWriter です。</param>
        public void WriteXml(XmlWriter writer)
        {
            string content = this.Count > 0 ? this[0].ToString() : string.Empty;
            for (int i = 1; i < this.Count; i++)
            {
                content += " " + this[i].ToString();
            }

            writer.WriteString(content);
        }
    }
}
