﻿// ========================================================================
// <copyright file="XmlDomContentResolver.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    /// <summary>
    /// XML文章への変換にシリアライザを利用するコンテンツを作成するリゾルバです。
    /// </summary>
    public class XmlDomContentResolver : XmlContentResolver
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="targetContentName">対象とするコンテンツの名前です。</param>
        public XmlDomContentResolver(string targetContentName)
            : base(targetContentName)
        {
        }

        /// <summary>
        /// IXmlContentインスタンスを生成します。
        /// <para>
        /// IXmlContentのサブクラスを実体化する場合は本メソッドをオーバーライドします。
        /// </para>
        /// </summary>
        /// <param name="xmlSubDocument">コンテンツXML文章です。</param>
        /// <returns>コンテンツの実体です。</returns>
        protected override IXmlContent CreateXmlContent(string xmlSubDocument)
        {
            Ensure.Argument.StringNotEmpty(xmlSubDocument);

            // コンテンツを作成して返します。
            return XmlDomContent.FromXml(xmlSubDocument);
        }
    }
}
