﻿// ========================================================================
// <copyright file="IXmlContentUpdater.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    /// <summary>
    /// コンテンツのバージョンアップを行うクラスが実装すべき機能を定義するインタフェースです。
    /// <remarks>
    /// システム内部でインスタンス生成をする都合、実装クラスにはデフォルトコンストラクタが必要です。
    /// </remarks>
    /// </summary>
    public interface IXmlContentUpdater
    {
        /// <summary>
        /// バージョン文字列を取得します。
        /// </summary>
        string Version { get; }

        /// <summary>
        /// XML文章にアップデート処理を施します。
        /// </summary>
        /// <param name="originalXmlString">バージョンアップ前のXML文章文字列です。</param>
        /// <returns>バージョンアップされたXML文章文字列です。</returns>
        string Update(string originalXmlString);
    }
}
