﻿// ========================================================================
// <copyright file="IXmlComplexReader.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    /// <summary>
    /// 複数種類のリソースが格納された、XML文章を読みとるクラスです。
    /// <para>
    /// XML文章をあらわす、文字列からリソース種類を束ねたデータを
    /// 表現するクラスを構築します。</para>
    /// </summary>
    public interface IXmlComplexReader
    {
        /// <summary>
        /// リゾルバが登録されているか取得します。
        /// </summary>
        /// <param name="resolver">リゾルバです。</param>
        /// <returns>登録されているかを返します。</returns>
        bool IsContainResolver(IXmlContentResolver resolver);

        /// <summary>
        /// リゾルバを登録します。
        /// 登録できない場合は例外
        /// (System.ArgumentException, System.NotSupportedException)を送出します。
        /// </summary>
        /// <param name="resolver">リゾルバです。</param>
        void RegisterResolver(IXmlContentResolver resolver);

        /// <summary>
        /// XML文章をよみこんで、ComplexDocumentを構築します。
        /// </summary>
        /// <param name="xmlDocumentString">XML文章です。</param>
        /// <returns>XML文章に対応するデータ構造です。</returns>
        IXmlComplexDocument Read(string xmlDocumentString);
    }
}

