﻿// ========================================================================
// <copyright file="ILog.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using System.ComponentModel;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ログのインターフェースです。
    /// </summary>
    public interface ILog : ICloneable, INotifyPropertyChanged, ISettable
    {
        //-----------------------------------------------------------------
        // プロパティの取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// ログの出力位置を取得します。
        /// </summary>
        ILogLocation Location { get; }

        /// <summary>
        /// ログのメッセージを取得または設定します。
        /// </summary>
        string Message { get; set; }

        /// <summary>
        /// ログが出力された日時を取得します。
        /// </summary>
        DateTime TimeStamp { get; }

        /// <summary>
        /// ログを設定します。
        /// </summary>
        /// <param name="log">設定するログです。</param>
        void Set(ILog log);
    }
}
