﻿// ========================================================================
// <copyright file="ILogger.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    /// <summary>
    /// 全てのログを受け取るリスナデリゲートです。
    /// </summary>
    /// <param name="log">追加されたログです。</param>
    /// <param name="logLevel">追加されたログのレベルです。</param>
    public delegate void AllLogListener(ILog log, LogLevel logLevel);

    /// <summary>
    /// ログのレベルです。
    /// </summary>
    public enum LogLevel
    {
        /// <summary>致命的な障害ログのレベルです。</summary>
        Fatal,

        /// <summary>エラーログのレベルです。</summary>
        Error,

        /// <summary>警告ログのレベルです。</summary>
        Warn,

        /// <summary>情報ログのレベルです。</summary>
        Info,

        /// <summary>デバッグログのレベルです。</summary>
        Debug,
    }

    /// <summary>
    /// ロガーのインターフェースです。
    /// </summary>
    public interface ILogger
    {
        //-----------------------------------------------------------------
        // ログのリスナ
        //-----------------------------------------------------------------

        /// <summary>
        /// 全てのログのリスナイベントです。
        /// </summary>
        event AllLogListener AllLogListener;

        //-----------------------------------------------------------------
        // プロパティの取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// 致命的な障害ログのログ入力です。
        /// </summary>
        ILogInput Fatal { get; }

        /// <summary>
        /// エラーログのログ入力です。
        /// </summary>
        ILogInput Error { get; }

        /// <summary>
        /// 警告ログのログ入力です。
        /// </summary>
        ILogInput Warn { get; }

        /// <summary>
        /// 情報ログのログ入力です。
        /// </summary>
        ILogInput Info { get; }

        /// <summary>
        /// デバッグ用ログのログ入力です。
        /// </summary>
        ILogInput Debug { get; }

        /// <summary>
        /// インデクサによりログ入力を取得します。
        /// </summary>
        /// <param name="logLevel">取得するログ入力のログレベルです。</param>
        /// <returns>指定したログレベルのログ入力です。</returns>
        ILogInput this[LogLevel logLevel] { get; }
    }
}
