﻿// ========================================================================
// <copyright file="TypeCouple.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Conversion
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// タイプペアです。
    /// </summary>
    public class TypeCouple
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="srcType">変換前の型です。</param>
        /// <param name="dstType">変換後の型です。</param>
        public TypeCouple(Type srcType, Type dstType)
        {
            this.SrcType = srcType;
            this.DstType = dstType;
        }

        /// <summary>
        /// 変換前の型です。
        /// </summary>
        public Type SrcType { get; set; }

        /// <summary>
        /// 変換後の型です。
        /// </summary>
        public Type DstType { get; set; }

        /// <summary>
        /// 反転したタイプペアを取得します。
        /// </summary>
        /// <returns>反転したタイプペアです。</returns>
        public TypeCouple Reverse()
        {
            return new TypeCouple(this.DstType, this.SrcType);
        }

        /// <summary>
        /// TypeCouple用比較クラスです。
        /// </summary>
        public class TypeCoupleComparer : IEqualityComparer<TypeCouple>
        {
            /// <summary>
            /// 等値であるかどうか比較します。
            /// </summary>
            /// <param name="x">比較対象です。</param>
            /// <param name="y">もう一つの比較対象です。</param>
            /// <returns>等値であれば true を返します。</returns>
            public bool Equals(TypeCouple x, TypeCouple y)
            {
                return x.SrcType == y.SrcType && x.DstType == y.DstType;
            }

            /// <summary>
            /// ハッシュ値を取得します。
            /// </summary>
            /// <param name="obj">ハッシュ値を計算するオブジェクトです。</param>
            /// <returns>ハッシュ値です。</returns>
            public int GetHashCode(TypeCouple obj)
            {
                return obj.SrcType.GetHashCode() ^ obj.DstType.GetHashCode();
            }
        }
    }
}
