﻿// ========================================================================
// <copyright file="CacheItem.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.ComponentModel
{
    using System;

    /// <summary>
    /// キャッシュアイテムです。
    /// </summary>
    public sealed class CacheItem
    {
        private readonly WeakReference keyObject;
        private readonly object value;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="keyObject">キャッシュのキーとなるオブジェクトを指定します。</param>
        /// <param name="value">キャッシュ値を指定します。</param>
        internal CacheItem(object keyObject, object value)
        {
            Ensure.Argument.NotNull(keyObject);
            Ensure.Argument.NotNull(value);

            this.keyObject = new WeakReference(keyObject);
            this.value = value;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// キャッシュ値の有効性を取得します。
        /// </summary>
        public bool IsValid
        {
            get
            {
                return this.keyObject.IsAlive;
            }
        }

        /// <summary>
        /// キャッシュのキーとなるオブジェクトを取得します。
        /// </summary>
        public object KeyObject
        {
            get
            {
                return this.keyObject.Target;
            }
        }

        /// <summary>
        /// キャッシュ値を取得します。
        /// </summary>
        public object Value
        {
            get
            {
                return this.IsValid ? this.value : null;
            }
        }
    }
}
