﻿// ========================================================================
// <copyright file="KeyedList.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.ObjectModel;

    /// <summary>
    /// 辞書引き可能なリストのデコレータです。
    /// </summary>
    /// <typeparam name="TKey">キーのテンプレート型です。</typeparam>
    /// <typeparam name="TValue">要素のテンプレート型です。</typeparam>
    public class KeyedList<TKey, TValue> : KeyedListDecorator<TKey, TValue>
    {
        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// デフォルトコンストラクタです。
        /// </summary>
        /// <param name="method">キーを決定するメソッドです。</param>
        public KeyedList(GetKeyForItemMethod method)
            : base(new ObservableCollection<TValue>(), method)
        {
        }
    }
}
