﻿// ========================================================================
// <copyright file="IKeyedList.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;

    /// <summary>
    /// キー検索可能なリスト機能を提供します。
    /// </summary>
    /// <typeparam name="TKey">キーの型を指定します。</typeparam>
    /// <typeparam name="TValue">値の型を指定します。</typeparam>
    public interface IKeyedList<TKey, TValue> : IList<TValue>
    {
        /// <summary>
        /// 指定されたキーがコレクション内に存在するかどうか調べます。
        /// </summary>
        /// <param name="key">アイテムのキーを指定します。</param>
        /// <returns>
        /// 指定されたキーがコレクション内に存在する場合は true、
        /// 存在しない場合は false を返します。
        /// </returns>
        bool ContainsKey(TKey key);

        /// <summary>
        /// 指定されたキーに関連付けられている値を取得します。
        /// </summary>
        /// <param name="key">アイテムのキーを指定します。</param>
        /// <returns>指定されたキーに関連付けられているアイテムを返します。</returns>
        TValue GetValue(TKey key);

        /// <summary>
        /// 指定されたキーに関連付けられている値を取得します。
        /// </summary>
        /// <param name="key">アイテムのキーを指定します。</param>
        /// <param name="value">
        /// 指定されたキーが存在する場合、そのキーに関連付けられている値を返します。
        /// それ以外の場合は value パラメータの型に対する既定の値を返します。
        /// </param>
        /// <returns>指定されたキーに関連付けられているアイテムを返します。</returns>
        bool TryGetValue(TKey key, out TValue value);
    }
}
