﻿// ========================================================================
// <copyright file="IEmitterSetDocument.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// エミッタセットドキュメント
    /// </summary>
    public interface IEmitterSetDocument : IDocument, IShowable
    {
        /// <summary>
        /// 要求されて読み込んだノードか？
        /// </summary>
        bool IsLinked { get; set; }

        /// <summary>
        /// エミッタドキュメントを列挙
        /// </summary>
        IEnumerable<IEmitterDocument> EmitterDocuments { get; }

        /// <summary>
        /// ゲーム設定ドキュメント（プレビューノード用）
        /// </summary>
        IEnumerable<IGameSettingsDocument> GameSettingsDocuments { get; }

        /// <summary>
        /// データモデル
        /// </summary>
        EmitterSetData EmitterSetData { get; }

        /// <summary>
        /// 関連するテクスチャのパスを取得します
        /// </summary>
        IEnumerable<string> TexturePaths { get; }

        /// <summary>
        /// 関連するテクスチャを取得します
        /// </summary>
        IEnumerable<EmitterAssetInfo> Textures { get; }

        /// <summary>
        /// 関連するプリミティブのパスを取得します
        /// </summary>
        IEnumerable<string> PrimitivePaths { get; }

        /// <summary>
        /// 関連するプリミティブを取得します
        /// </summary>
        IEnumerable<EmitterAssetInfo> Primitives { get; }

        /// <summary>
        /// プロジェクト
        /// </summary>
        IProjectDocument Project { get; }

        /// <summary>
        /// get emitter document by index
        /// </summary>
        /// <param name="index">index of the document</param>
        /// <returns></returns>
        IEmitterDocument GetEmitterDocumentByIndex(int index);

        /// <summary>
        /// get number ofemitter documents
        /// </summary>
        int GetEmitterDocumentCount();

            /// <summary>
        /// 自身を複製する
        /// </summary>
        /// <param name="name">複製先の名前</param>
        /// <param name="project">複製先のプロジェクト</param>
        /// <returns>複製したオブジェクト</returns>
        IEmitterSetDocument DuplicateSelf(string name, IProjectDocument project);

        /// <summary>
        /// EmitterDocumentを追加します
        /// </summary>
        /// <param name="index">挿入する位置のインデックスです / =-1..最後に追加</param>
        /// <param name="document">追加するEmitterDocumentです</param>
        void AddEmitterDocument( IEmitterDocument document, int iIndex );

        /// <summary>
        /// EmitterDocumentを削除します。
        /// </summary>
        /// <param name="document">削除するEmitterDocumentです</param>
        /// <returns>挿入されていたインデックスを返します</returns>
        int RemoveEmitterDocument(IEmitterDocument document);
    }
}
