﻿// ========================================================================
// <copyright file="RequireDocData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using NWCore.Protocols;

namespace NWCore.DataModel.Major_1.Minor_2.Build_0.Revision_0
{
    /// <summary>
    /// 要求（Viewerから要求されたノード）
    /// </summary>
    public class RequireDocData : BaseDataModel<RequireDocData>
    {
        #region プロパティ

        /// <summary>
        /// 要求名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// ファイルパス
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// 要求タイプ
        /// </summary>
        public BinaryDataType BinaryType { get; set; }

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public RequireDocData()
        {
            Initialize();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public RequireDocData(string nodeName, BinaryDataType binType, StringType strType)
        {
            if (strType == StringType.Name)
            {
                this.Name = nodeName;
                this.Path = string.Empty;
            }
            else
            {
                this.Name = System.IO.Path.GetFileNameWithoutExtension(nodeName);
                this.Path = nodeName;
            }
            this.BinaryType = binType;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="source"></param>
        public RequireDocData(RequireDocData source)
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Name = string.Empty;
            this.Path = string.Empty;
            this.BinaryType = BinaryDataType.None;
        }

        /// <summary>
        /// クローン
        /// </summary>
        public override RequireDocData Clone()
        {
            return new RequireDocData(this);
        }

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(RequireDocData source)
        {
            this.Name = source.Name;
            this.Path = source.Path;
            this.BinaryType = source.BinaryType;
        }
    }
}
