﻿// ========================================================================
// <copyright file="EditDataEmitter.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NWCore.Serializer.Major_1.Minor_2.Build_0.Revision_0;

namespace NWCore.DataModel.Major_1.Minor_2.Build_0.Revision_0
{
    /// <summary>
    /// 編集データ：Emitter用
    /// </summary>
    public class EditDataEmitter : BaseEditData
    {
        #region Property

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment
        {
            get;
            set;
        }

        #endregion

        #region 初期化

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitter()
        {
            Initialize();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitter(EditDataEmitter other)
            : this()
        {
            this.Set(other);
        }

        /// <summary>
        /// シリアライズ用オブジェクトを生成します。
        /// </summary>
        /// <returns></returns>
        public EditDataEmitterXml CreateEditDataXml()
        {
            return new EditDataEmitterXml(this);
        }

        #endregion

        #region override

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Comment = System.String.Empty;
        }

        /// <summary>
        /// 複製
        /// </summary>
        public override object Clone()
        {
            return new EditDataEmitter(this);
        }

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(object source)
        {
            EditDataEmitter srcInst = source as EditDataEmitter;
            Debug.Assert(srcInst != null);

            this.Comment = srcInst.Comment;
        }

        #endregion
    }
}
