﻿// ========================================================================
// <copyright file="EditDataEmitterSet.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System.Diagnostics;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.Serializer.Major_0.Minor_0.Build_0.Revision_0;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// 編集データ：EmitterSet用
    /// </summary>
    public class EditDataEmitterSet : BaseEditData
    {
        #region Property

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment
        {
            get;
            set;
        }

        /// <summary>
        /// カラーラベルのインデックス
        /// </summary>
        public int ColorLabelIndex
        {
            get;
            set;
        }

        /// <summary>
        /// カラーラベルを取得
        /// </summary>
        public RgbaColor ColorLabel
        {
            get { return ColorLabelTable.GetColor(this.ColorLabelIndex); }
        }

        #endregion

        #region コンストラクタ＆初期化

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitterSet()
        {
            Initialize();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitterSet(EditDataEmitterSet other)
            : this()
        {
            this.Set(other);
        }

        /// <summary>
        /// シリアライズ用オブジェクトを生成します。
        /// </summary>
        /// <returns></returns>
        public EditDataEmitterSetXml CreateEditDataXml()
        {
            return new EditDataEmitterSetXml(this);
        }

        #endregion

        #region override

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.ColorLabelIndex = ColorLabelTable.DefaultColorIndex;
            this.Comment = System.String.Empty;
        }

        /// <summary>
        /// 複製
        /// </summary>
        public override object Clone()
        {
            return new EditDataEmitterSet(this);
        }

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set(object source)
        {
            EditDataEmitterSet srcInst = source as EditDataEmitterSet;
            Debug.Assert(srcInst != null);

            this.Comment = srcInst.Comment;
            this.ColorLabelIndex = srcInst.ColorLabelIndex;
        }

        #endregion

    }
}
