﻿/*---------------------------------------------------------------------------*
 Copyright (C) 2013 Nintendo Co., Ltd.  All rights reserved.

 These coded instructions, statements, and computer programs contain
 proprietary information of Nintendo of America Inc. and/or Nintendo
 Company Ltd., and are protected by Federal copyright law.  They may
 not be disclosed to third parties or copied or duplicated in any form,
 in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
// 定義
//------------------------------------------------------------------------------
// 頂点シェーダであることの定義
#define VERTEX_SHADER


//------------------------------------------------------------------------------
// OPENGL_ES2で不足する関数
//------------------------------------------------------------------------------
mat4 transpose( mat4 inMtx )
{
    vec4 m0 = inMtx[0];
    vec4 m1 = inMtx[1];
    vec4 m2 = inMtx[2];
    vec4 m3 = inMtx[3];

    mat4 ret = mat4(
                 vec4( m0.x, m1.x, m2.x, m3.x ),
                 vec4( m0.y, m1.y, m2.y, m3.y ),
                 vec4( m0.z, m1.z, m2.z, m3.z ),
                 vec4( m0.w, m1.w, m2.w, m3.w )
                 );
    return ret;
}


//------------------------------------------------------------------------------
// Attribute 置き換え
//------------------------------------------------------------------------------
#define _ATTRIBUTE_IN    attribute

//------------------------------------------------------------------------------
// Varying 置き換え
//------------------------------------------------------------------------------
#define _VARYING_OUT     varying

//------------------------------------------------------------------------------
// 入力
//------------------------------------------------------------------------------

// 頂点単位
_ATTRIBUTE_IN vec4     sysPosAttr;                                     // 入力頂点 ( -0.5, 0.5 ) -> ( 0.5, -0.5 )
_ATTRIBUTE_IN vec4     sysTexCoordAttr;                                // 入力テクスチャ座標　(プリミティブ利用時)
_ATTRIBUTE_IN vec4     sysVertexColor0Attr;                            // 入力カラー　　　　　(プリミティブ/ストライプ利用時)



//------------------------------------------------------------------------------
// パーティクル1枚単位 入力
//------------------------------------------------------------------------------
#ifdef EFT_USE_REGISTER_DRAW
uniform vec4        sysLocalPosAttr;                            // ローカル座標 / パーティクル寿命
uniform vec4        sysLocalVecAttr;                            // ローカルベクトル / エミッタ放出時タイム
uniform vec4        sysLocalDiffAttr;                           // ローカル位置差分 / 空き
uniform vec4        sysScaleAttr;                               // パーティクルスケール(xyz) / 運動量ランダム
uniform vec4        sysRandomAttr;                              // パーティクル固有ランダム
uniform vec4        sysInitRotateAttr;                          // パーティクル初期回転 / エミッタ放出時タイム
uniform vec4        sysEmtMat0Attr;                             // エミッタマトリクス0
uniform vec4        sysEmtMat1Attr;                             // エミッタマトリクス1
uniform vec4        sysEmtMat2Attr;                             // エミッタマトリクス2
uniform vec4        sysEmtRTMat0Attr;                           // エミッタRTマトリクス0
uniform vec4        sysEmtRTMat1Attr;                           // エミッタRTマトリクス1
uniform vec4        sysEmtRTMat2Attr;                           // エミッタRTマトリクス2
uniform vec4        sysColor0Attr;                              // パーティクル初期カラー0
uniform vec4        sysColor1Attr;                              // パーティクル初期カラー1
#endif
#ifdef EFT_USE_INSTANS_DRAW
_ATTRIBUTE_IN vec4  sysLocalPosAttr;                            // ローカル座標 / パーティクル寿命
_ATTRIBUTE_IN vec4  sysLocalVecAttr;                            // ローカルベクトル / エミッタ放出時タイム
_ATTRIBUTE_IN vec4  sysLocalDiffAttr;                           // ローカル位置差分 / 空き
_ATTRIBUTE_IN vec4  sysScaleAttr;                               // パーティクルスケール /
_ATTRIBUTE_IN vec4  sysRandomAttr;                              // パーティクル固有ランダム
_ATTRIBUTE_IN vec4  sysInitRotateAttr;                          // パーティクル初期回転
_ATTRIBUTE_IN vec4  sysEmtMat0Attr;                             // エミッタマトリクス0
_ATTRIBUTE_IN vec4  sysEmtMat1Attr;                             // エミッタマトリクス1
_ATTRIBUTE_IN vec4  sysEmtMat2Attr;                             // エミッタマトリクス2
_ATTRIBUTE_IN vec4  sysEmtRTMat0Attr;                           // エミッタRTマトリクス0
_ATTRIBUTE_IN vec4  sysEmtRTMat1Attr;                           // エミッタRTマトリクス1
_ATTRIBUTE_IN vec4  sysEmtRTMat2Attr;                           // エミッタRTマトリクス2
_ATTRIBUTE_IN vec4  sysColor0Attr;                              // パーティクル初期カラー0
_ATTRIBUTE_IN vec4  sysColor1Attr;                              // パーティクル初期カラー1
#endif


//------------------------------------------------------------------------------
// 出力
//------------------------------------------------------------------------------
_VARYING_OUT vec4    sysColor0Vary;                      // カラー0

#if defined( _COLOR_PROCESS_TEXTURE_INTERPOLATE ) || defined( _COLOR_PROCESS_TEXTURE_ADD )
_VARYING_OUT vec4    sysColor1Vary;                      // カラー1
#endif

#ifdef _PRIMITIVE
_VARYING_OUT vec4    sysPrimitiveColorVary;              // プリミティブカラー
#endif

#if defined( _TEXTURE0_ENABLE ) || defined( _TEXTURE1_ENABLE )
_VARYING_OUT vec4    sysTexCoord01Vary;                  // テクスチャ座標0-1
#endif

#ifdef _TEXTURE2_ENABLE
_VARYING_OUT vec2    sysTexCoord2Vary;                   // テクスチャ座標2
#endif

_VARYING_OUT vec4    sysFlagParamVary;                   // 各種パラメータ( alphaRate )

#if defined( _SHADER_TYPE_REFRACT ) || defined( _SHADER_TYPE_DISTORTION )
_VARYING_OUT vec4    sysFlagCoordVary;                   // スクリーン座標参照用
#endif


//------------------------------------------------------------------------------
// エミッタRTマトリクス MakesysEmitterRTMatrixで生成されます。
//------------------------------------------------------------------------------
vec4 sysEmitterRT[3];   // 今のEmitterの位置を表すRTマトリクス。


//------------------------------------------------------------------------------
// パーティクル情報
//------------------------------------------------------------------------------
float   sysPtclTime;                                        // パーティクル タイム
float   sysPtclAlphaRate;                                   // パーティクル アルファ係数
vec3    sysPtclScale;                                       // パーティクルスケール
vec3    sysPtclLocalPos;                                    // パーティクルローカル座標
vec3    sysPtclLocalVec;                                    // パーティクルローカル速度
vec3    sysPtclWorldPos;                                    // パーティクル世界座標
vec3    sysPtclWorldPosDelta;                               // パーティクル移動差分
mat4    sysPtclRotateMatrix;                                // パーティクル回転行列
vec4    sysPtclFlagCoordCenter;                             // スクリーン座標での位置
float   sysPtclVertexDepthValue;                            // 頂点のデプス値
float   sysPtclVertexDepthValueCenter;                      // 頂点のデプス値（パーティクルの中心）
float   sysPtclTextureDepthValue;                           // テクスチャのデプス値
#define sysPtclRandomX         sysRandomAttr.x              // パーティクル 固有ランダムX
#define sysPtclRandomY         sysRandomAttr.y              // パーティクル 固有ランダムY
#define sysPtclRandomZ         sysRandomAttr.z              // パーティクル 固有ランダムZ
#define sysPtclRandomW         sysRandomAttr.w              // パーティクル 固有ランダムW

#define sysPtclEmitTime        sysLocalVecAttr.w            // パーティクル 放出エミッタ時間
#define sysPtclLife            sysLocalPosAttr.w            // パーティクル 寿命


