﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/磁力タブ/磁力グループデータです。
    /// </summary>
    [Serializable]
    public class MagnetParamData : DataModelBase
    {
        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        private Vector3f magnetPos = null;

        /// <summary>
        /// 磁力のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public MagnetParamData() :
            base()
        {
            this.MagnetPower = 0.001f;
            this.MagnetPos = new Vector3f(0.0f, 0.0f, 0.0f);
            this.FollowEmitter = false;
            this.EnableAxisX = true;
            this.EnableAxisY = true;
            this.EnableAxisZ = true;
            this.EnableAnimation = 0;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 磁力の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e4397697-3102-43b5-9579-e258abb4548c")]
        public float MagnetPower { get; set; }

        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("54072949-e538-4b36-bdb5-866023c068bd")]
        public Vector3f MagnetPos
        {
            get { return this.GetObjectFromField(ref this.magnetPos, false); }
            set { this.SetISettableToField(ref this.magnetPos, value); }
        }

        /// <summary>
        /// 位置をエミッタに追従のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("59047701-6603-4835-95a8-2ea39aa1e759")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// 対象座標軸X軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d80f1128-5f61-4fc4-b491-fd671ac803d2")]
        public bool EnableAxisX { get; set; }

        /// <summary>
        /// 対象座標軸Y軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("33be7ebe-0785-499a-95f9-378d8af7179d")]
        public bool EnableAxisY { get; set; }

        /// <summary>
        /// 対象座標軸Z軸のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("166e6021-ffab-4340-a104-e02f137ab5b3")]
        public bool EnableAxisZ { get; set; }

        /// <summary>
        /// 磁力のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7e55448f-8ccc-436e-9f0c-a2153f7b3271")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 磁力のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a7f08f5d-d451-4429-88b0-88d96b866fb2")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 磁力のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("36b514c8-1068-4905-b3d6-e7a678b502d9")]
        public int LoopMode { get; set; }

        /// <summary>
        /// 磁力のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("d79ac03b-61d7-4e46-a3be-a399649cd39b")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 磁力のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f48306f8-b601-458e-af8e-9b1a0ebc9fbf")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.MagnetParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MagnetPower = srcDataModel.MagnetPower;
            this.MagnetPos = srcDataModel.MagnetPos;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAxisX = srcDataModel.EnableAxisX;
            this.EnableAxisY = srcDataModel.EnableAxisY;
            this.EnableAxisZ = srcDataModel.EnableAxisZ;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "MagnetPower", this.MagnetPower);
            this.WriteElement(context, "MagnetPos", this.MagnetPos);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "EnableAxisX", this.EnableAxisX);
            this.WriteElement(context, "EnableAxisY", this.EnableAxisY);
            this.WriteElement(context, "EnableAxisZ", this.EnableAxisZ);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.MagnetPower = this.ReadElement(context, "MagnetPower", this.MagnetPower);
            this.MagnetPos = this.ReadElement(context, "MagnetPos", this.MagnetPos);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.EnableAxisX = this.ReadElement(context, "EnableAxisX", this.EnableAxisX);
            this.EnableAxisY = this.ReadElement(context, "EnableAxisY", this.EnableAxisY);
            this.EnableAxisZ = this.ReadElement(context, "EnableAxisZ", this.EnableAxisZ);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.MagnetParamData(PrevVersion.MagnetParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.MagnetParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.MagnetParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.MagnetPower = srcDataModel.MagnetPower;
            this.MagnetPos = srcDataModel.MagnetPos;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAxisX = srcDataModel.EnableAxisX;
            this.EnableAxisY = srcDataModel.EnableAxisY;
            this.EnableAxisZ = srcDataModel.EnableAxisZ;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
