﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Class for preview data.
    /// </summary>
    [Serializable]
    public class PreviewBasicPlaybackData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewBasicPlaybackData() :
            base()
        {
            this.PreviewStartFrame = 0;
            this.PreviewEndFrame = 0;
            this.IsManualEmitter = false;
            this.EmitterInterval = 10;
            this.MaxEmitCountPerFrame = 1;

            this.PostConstruct();
        }

        /// <summary>
        /// 再生開始フレームです.
        /// </summary>
        [DataModelPropertyGuid("079df94b-a6b8-435e-9885-2eb18a08266b")]
        public int PreviewStartFrame { get; set; }

        /// <summary>
        /// 再生範囲の終了フレームです.
        /// </summary>
        [DataModelPropertyGuid("5d11e7e3-5044-4b4a-a4d2-aff740329f50")]
        public int PreviewEndFrame { get; set; }

        /// <summary>
        /// マニュアルエミッタ放出をします。
        /// </summary>
        [DataModelPropertyGuid("5ec61b5e-e88e-49cc-9450-5097e85089d7")]
        public bool IsManualEmitter { get; set; }

        /// <summary>
        /// マニュアルエミッタ放出間隔です。
        /// </summary>
        [DataModelPropertyGuid("6ded2c00-c0da-4029-afec-0476b72a9166")]
        public int EmitterInterval { get; set; }

        /// <summary>
        /// 1フレーム中に放出予約可能なパーティクルの最大数です。
        /// </summary>
        [DataModelPropertyGuid("49b8c593-41fe-4d99-a5f4-4ebe57337a41")]
        public int MaxEmitCountPerFrame { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewBasicPlaybackData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.PreviewStartFrame = srcDataModel.PreviewStartFrame;
            this.PreviewEndFrame = srcDataModel.PreviewEndFrame;
            this.IsManualEmitter = srcDataModel.IsManualEmitter;
            this.EmitterInterval = srcDataModel.EmitterInterval;
            this.MaxEmitCountPerFrame = srcDataModel.MaxEmitCountPerFrame;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "PreviewStartFrame", this.PreviewStartFrame);
            this.WriteElement(context, "PreviewEndFrame", this.PreviewEndFrame);
            this.WriteElement(context, "IsManualEmitter", this.IsManualEmitter);
            this.WriteElement(context, "EmitterInterval", this.EmitterInterval);
            this.WriteElement(context, "MaxEmitCountPerFrame", this.MaxEmitCountPerFrame);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.PreviewStartFrame = this.ReadElement(context, "PreviewStartFrame", this.PreviewStartFrame);
            this.PreviewEndFrame = this.ReadElement(context, "PreviewEndFrame", this.PreviewEndFrame);
            this.IsManualEmitter = this.ReadElement(context, "IsManualEmitter", this.IsManualEmitter);
            this.EmitterInterval = this.ReadElement(context, "EmitterInterval", this.EmitterInterval);
            this.MaxEmitCountPerFrame = this.ReadElement(context, "MaxEmitCountPerFrame", this.MaxEmitCountPerFrame);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewBasicPlaybackData(PrevVersion.PreviewBasicPlaybackData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewBasicPlaybackData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewBasicPlaybackData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.PreviewStartFrame = srcDataModel.PreviewStartFrame;
            this.PreviewEndFrame = srcDataModel.PreviewEndFrame;
            this.IsManualEmitter = srcDataModel.IsManualEmitter;
            this.EmitterInterval = srcDataModel.EmitterInterval;
            this.MaxEmitCountPerFrame = srcDataModel.MaxEmitCountPerFrame;

            return true;
        }
    }
}
