﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/カラー計算グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorCalculationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorCalculationData() :
            base()
        {
            this.ColorScale = 1.0f;
            this.ColorAlphaFixFlag = false;

            this.PostConstruct();
        }

        /// <summary>
        /// カラースケールを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ce747b39-a8df-4d5b-a30f-b361c0d41125")]
        public float ColorScale { get; set; }

        /// <summary>
        /// カラー・アルファ固定のOn/Offを取得または設定します。
        /// 現在この値は使用していません。
        /// </summary>
        [DataModelPropertyGuid("009a0616-251e-4213-9d61-c973d9c3db9d")]
        public bool ColorAlphaFixFlag { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorCalculationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ColorScale = srcDataModel.ColorScale;
            this.ColorAlphaFixFlag = srcDataModel.ColorAlphaFixFlag;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ColorScale", this.ColorScale);
            this.WriteElement(context, "ColorAlphaFixFlag", this.ColorAlphaFixFlag);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ColorScale = this.ReadElement(context, "ColorScale", this.ColorScale);
            this.ColorAlphaFixFlag = this.ReadElement(context, "ColorAlphaFixFlag", this.ColorAlphaFixFlag);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorCalculationData(PrevVersion.EmitterColorCalculationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorCalculationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorCalculationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ColorScale = srcDataModel.ColorScale;
            this.ColorAlphaFixFlag = srcDataModel.ColorAlphaFixFlag;

            return true;
        }
    }
}
