﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicAnimationData() :
            base()
        {
            this.AnimationFolderPath = string.Empty;
            this.AnimationFilePath = string.Empty;
            this.AnimationFile = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// アニメーションフォルダパスです。
        /// </summary>
        [DataModelPropertyGuid("f55d156d-1ab0-49aa-9fa4-759de7070c22")]
        public string AnimationFolderPath { get; set; }

        /// <summary>
        /// アニメーションファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("9cd4d85d-28cb-4198-8f92-157caf588b27")]
        public string AnimationFilePath { get; set; }

        /// <summary>
        /// アニメーションファイルです。
        /// </summary>
        [DataModelPropertyGuid("7ed75f55-10e1-443b-8c6c-74c27b62b726")]
        public int AnimationFile { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelBasicAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationFolderPath = srcDataModel.AnimationFolderPath;
            this.AnimationFilePath = srcDataModel.AnimationFilePath;
            this.AnimationFile = srcDataModel.AnimationFile;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AnimationFolderPath", this.AnimationFolderPath);
            this.WriteElement(context, "AnimationFilePath", this.AnimationFilePath);
            this.WriteElement(context, "AnimationFile", this.AnimationFile);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AnimationFolderPath = this.ReadElement(context, "AnimationFolderPath", this.AnimationFolderPath);
            this.AnimationFilePath = this.ReadElement(context, "AnimationFilePath", this.AnimationFilePath);
            this.AnimationFile = this.ReadElement(context, "AnimationFile", this.AnimationFile);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ModelBasicAnimationData(PrevVersion.ModelBasicAnimationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ModelBasicAnimationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ModelBasicAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.AnimationFolderPath = srcDataModel.AnimationFolderPath;
            this.AnimationFilePath = srcDataModel.AnimationFilePath;
            this.AnimationFile = srcDataModel.AnimationFile;

            return true;
        }
    }
}
