﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// パーティクル放出タブデータです。
    /// </summary>
    [Serializable]
    public class PreviewParticleEmissionData : DataModelBase
    {
        /// <summary>
        /// 速度方向
        /// </summary>
        private Vector3f setAddVelValue = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewParticleEmissionData() :
            base()
        {
            this.EmissionRate = 1.0f;
            this.EmissionInterval = 1.0f;
            this.SetAllDirectionalVelScale = 1.0f;
            this.SetDirectionalVelScale = 1.0f;
            this.SetRandomVelScale = 1.0f;
            this.SetAddVelValue = new Vector3f(0.0f, 0.0f, 0.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// 放出レート(EmitterController::SetEmissionRatio)
        /// </summary>
        [DataModelPropertyGuid("92a2d12c-5c6e-462a-8505-0518f7c9fa19")]
        public float EmissionRate { get; set; }

        /// <summary>
        /// 放出間隔(EmitterController::SetEmissionInterval)
        /// </summary>
        [DataModelPropertyGuid("03455062-4d17-47fa-a5bf-5eccb2083dd5")]
        public float EmissionInterval { get; set; }

        /// <summary>
        /// 全方向初速
        /// </summary>
        [DataModelPropertyGuid("583f5076-a5bc-430d-a1a2-5ed06d9f60e1")]
        public float SetAllDirectionalVelScale { get; set; }

        /// <summary>
        /// 指定方向初速スケール
        /// </summary>
        [DataModelPropertyGuid("ac8667a2-2d77-48e1-a202-34d28f2ae9cc")]
        public float SetDirectionalVelScale { get; set; }

        /// <summary>
        /// 初速度のランダム
        /// </summary>
        [DataModelPropertyGuid("d9bed353-1219-45ba-9bca-5cc1031d621a")]
        public float SetRandomVelScale { get; set; }

        /// <summary>
        /// 速度方向
        /// </summary>
        [DataModelPropertyGuid("ae495e96-e823-4d52-9650-9b87fa6f9c6e")]
        public Vector3f SetAddVelValue
        {
            get { return this.GetObjectFromField(ref this.setAddVelValue, false); }
            set { this.SetISettableToField(ref this.setAddVelValue, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewParticleEmissionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmissionRate = srcDataModel.EmissionRate;
            this.EmissionInterval = srcDataModel.EmissionInterval;
            this.SetAllDirectionalVelScale = srcDataModel.SetAllDirectionalVelScale;
            this.SetDirectionalVelScale = srcDataModel.SetDirectionalVelScale;
            this.SetRandomVelScale = srcDataModel.SetRandomVelScale;
            this.SetAddVelValue = srcDataModel.SetAddVelValue;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmissionRate", this.EmissionRate);
            this.WriteElement(context, "EmissionInterval", this.EmissionInterval);
            this.WriteElement(context, "SetAllDirectionalVelScale", this.SetAllDirectionalVelScale);
            this.WriteElement(context, "SetDirectionalVelScale", this.SetDirectionalVelScale);
            this.WriteElement(context, "SetRandomVelScale", this.SetRandomVelScale);
            this.WriteElement(context, "SetAddVelValue", this.SetAddVelValue);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmissionRate = this.ReadElement(context, "EmissionRate", this.EmissionRate);
            this.EmissionInterval = this.ReadElement(context, "EmissionInterval", this.EmissionInterval);
            this.SetAllDirectionalVelScale = this.ReadElement(context, "SetAllDirectionalVelScale", this.SetAllDirectionalVelScale);
            this.SetDirectionalVelScale = this.ReadElement(context, "SetDirectionalVelScale", this.SetDirectionalVelScale);
            this.SetRandomVelScale = this.ReadElement(context, "SetRandomVelScale", this.SetRandomVelScale);
            this.SetAddVelValue = this.ReadElement(context, "SetAddVelValue", this.SetAddVelValue);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewParticleEmissionData(PrevVersion.PreviewParticleEmissionData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewParticleEmissionData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewParticleEmissionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmissionRate = srcDataModel.EmissionRate;
            this.EmissionInterval = srcDataModel.EmissionInterval;
            this.SetAllDirectionalVelScale = srcDataModel.SetAllDirectionalVelScale;
            this.SetDirectionalVelScale = srcDataModel.SetDirectionalVelScale;
            this.SetRandomVelScale = srcDataModel.SetRandomVelScale;
            this.SetAddVelValue = srcDataModel.SetAddVelValue;

            return true;
        }
    }
}
