﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_4;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationData : DataModelBase
    {
        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        private EmitterRotationBasicData emitterRotationBasicData = null;

        /// <summary>
        /// 回転軸Xグループデータを取得または設定します。
        /// </summary>
        private EmitterRotationXData emitterRotationXData = null;

        /// <summary>
        /// 回転軸Yグループデータを取得または設定します。
        /// </summary>
        private EmitterRotationYData emitterRotationYData = null;

        /// <summary>
        /// 回転軸Zグループデータを取得または設定します。
        /// </summary>
        private EmitterRotationZData emitterRotationZData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d7092259-2937-44ce-be23-638912b8d67b")]
        public EmitterRotationBasicData EmitterRotationBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationBasicData, value); }
        }

        /// <summary>
        /// 回転軸Xグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("dc0bd411-2f87-4994-a2c8-37a2d09e683f")]
        public EmitterRotationXData EmitterRotationXData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationXData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationXData, value); }
        }

        /// <summary>
        /// 回転軸Yグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5c2901c6-6f5d-498c-80b0-7085faec7fb6")]
        public EmitterRotationYData EmitterRotationYData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationYData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationYData, value); }
        }

        /// <summary>
        /// 回転軸Zグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("36e6d347-d7ab-4e60-a235-032fec9c24f1")]
        public EmitterRotationZData EmitterRotationZData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationZData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationZData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterRotationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterRotationBasicData = srcDataModel.EmitterRotationBasicData;
            this.EmitterRotationXData = srcDataModel.EmitterRotationXData;
            this.EmitterRotationYData = srcDataModel.EmitterRotationYData;
            this.EmitterRotationZData = srcDataModel.EmitterRotationZData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterRotationBasicData", this.EmitterRotationBasicData);
            this.WriteElement(context, "EmitterRotationXData", this.EmitterRotationXData);
            this.WriteElement(context, "EmitterRotationYData", this.EmitterRotationYData);
            this.WriteElement(context, "EmitterRotationZData", this.EmitterRotationZData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterRotationBasicData = this.ReadElement(context, "EmitterRotationBasicData", this.EmitterRotationBasicData);
            this.EmitterRotationXData = this.ReadElement(context, "EmitterRotationXData", this.EmitterRotationXData);
            this.EmitterRotationYData = this.ReadElement(context, "EmitterRotationYData", this.EmitterRotationYData);
            this.EmitterRotationZData = this.ReadElement(context, "EmitterRotationZData", this.EmitterRotationZData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterRotationData(PrevVersion.EmitterRotationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterRotationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterRotationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterRotationBasicData = srcDataModel.EmitterRotationBasicData;
            this.EmitterRotationXData = srcDataModel.EmitterRotationXData;
            this.EmitterRotationYData = srcDataModel.EmitterRotationYData;
            this.EmitterRotationZData = srcDataModel.EmitterRotationZData;

            return true;
        }
    }
}
