﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノードです。
    /// </summary>
    [Serializable]
    public class ViewerData : DataModelBase
    {
        /// <summary>
        /// モデルリストです.
        /// </summary>
        private List<ModelData> modelList = null;

        /// <summary>
        /// 背景画像タブです.
        /// </summary>
        private ViewerBackgroundData viewerBackgroundData = null;

        /// <summary>
        /// カメラタブです。
        /// </summary>
        private ViewerCameraData viewerCameraData = null;

        /// <summary>
        /// 基本設定タブです。
        /// </summary>
        private ViewerBasicData viewerBasicData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerData() :
            base()
        {
            this.modelList = new List<ModelData>(){
                new ModelData(),
                new ModelData(),
                new ModelData(),
                new ModelData(),
                new ModelData(),
            };

            this.PostConstruct();
        }

        /// <summary>
        /// モデルリストです.
        /// </summary>
        [DataModelPropertyGuid("28dc1b89-7c2c-430d-b12e-8ea50bfaf951")]
        public List<ModelData> ModelList
        {
            get { return this.GetDataModelListFromField(ref this.modelList); }
            set { this.SetDataModelListToField(ref this.modelList, value); }
        }

        /// <summary>
        /// 背景画像タブです.
        /// </summary>
        [DataModelPropertyGuid("442c7903-fc2b-4ce2-8917-f605fb8234c3")]
        public ViewerBackgroundData ViewerBackgroundData
        {
            get { return this.GetDataModelFromField(ref this.viewerBackgroundData, false); }
            set { this.SetDataModelToField(ref this.viewerBackgroundData, value); }
        }

        /// <summary>
        /// カメラタブです。
        /// </summary>
        [DataModelPropertyGuid("79afdf4d-9b69-4ada-ad90-ffc3f697335c")]
        public ViewerCameraData ViewerCameraData
        {
            get { return this.GetDataModelFromField(ref this.viewerCameraData, false); }
            set { this.SetDataModelToField(ref this.viewerCameraData, value); }
        }

        /// <summary>
        /// 基本設定タブです。
        /// </summary>
        [DataModelPropertyGuid("752625f8-8fca-4265-a2cd-792beffde63b")]
        public ViewerBasicData ViewerBasicData
        {
            get { return this.GetDataModelFromField(ref this.viewerBasicData, false); }
            set { this.SetDataModelToField(ref this.viewerBasicData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelList = srcDataModel.ModelList;
            this.ViewerBackgroundData = srcDataModel.ViewerBackgroundData;
            this.ViewerCameraData = srcDataModel.ViewerCameraData;
            this.ViewerBasicData = srcDataModel.ViewerBasicData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteEnumerableElement(context, "ModelList", this.ModelList);
            this.WriteElement(context, "ViewerBackgroundData", this.ViewerBackgroundData);
            this.WriteElement(context, "ViewerCameraData", this.ViewerCameraData);
            this.WriteElement(context, "ViewerBasicData", this.ViewerBasicData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ModelList = this.ReadListElement(context, "ModelList", this.ModelList);
            this.ViewerBackgroundData = this.ReadElement(context, "ViewerBackgroundData", this.ViewerBackgroundData);
            this.ViewerCameraData = this.ReadElement(context, "ViewerCameraData", this.ViewerCameraData);
            this.ViewerBasicData = this.ReadElement(context, "ViewerBasicData", this.ViewerBasicData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerData(PrevVersion.ViewerData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ModelList = srcDataModel.ModelList.Select(dm => (CurrVersion.ModelData)dm).ToList();
            this.ViewerBackgroundData = srcDataModel.ViewerBackgroundData;
            this.ViewerCameraData = srcDataModel.ViewerCameraData;
            this.ViewerBasicData = srcDataModel.ViewerBasicData;

            return true;
        }
    }
}
